// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          logbooknamedialog.h  -  description
                             -------------------
    begin                : Sam Apr 13 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.1 $
    date                 : $Date: 2002/04/13 18:26:56 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOGBOOKNAMEDIALOG_H
#define LOGBOOKNAMEDIALOG_H


#include <qstring.h>

#include "logbooknamedialoggui.h"



//! Simple Dialog to change the name of a logbook
/*! Simple Dialog to change the name of a logbook
 */
class LogBookNameDialog : public LogBookNameDialogGUI  {

    Q_OBJECT

public: 
    //! Default Constructor
    LogBookNameDialog( QWidget *parent = 0, const char *name = 0, bool modal = true );

    //! Constructor that sets an initial name
    LogBookNameDialog( const QString &logBookName, QWidget *parent = 0, 
		       const char *name = 0, bool modal = true );

    //! Default Destructor
    ~LogBookNameDialog();

    //! Function to set a name in the LineEdit
    void setName( const QString &name );

    //! Function to read out the entered name
    QString name( void );
};

#endif
