/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifndef KMLOFAX_H 
#define KMLOFAX_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qframe.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qpopupmenu.h>
#include <qptrlist.h>

#include <kprogress.h>
#include <kuniqueapplication.h>
#include <klocale.h>
#include <kmainwindow.h>
#include <kconfig.h>
#include <kprocess.h>
#include <kaction.h>


#include "faxfiler.h"
#include "mloloader.h"
#include "preview.h"

#include <X11/Xlib.h>



class StatusProgress: public QFrame
{
	Q_OBJECT
public:
	StatusProgress(QWidget *parent = 0, const char *name = 0);
	~StatusProgress();

	void setEnabled(bool enable);
	
public slots:
	void setTotalSteps(int totalSteps);
	void setProgress(int valus);

protected slots:
	void abortSlot();

signals:
	void aborted();

private:
	QPushButton *abort;
	KProgress *progress;
};


inline void	StatusProgress::setTotalSteps(int totalSteps)
{	progress->setRange(0, totalSteps); }


inline void	StatusProgress::setProgress(int value)
{	progress->setValue(value); }




class KMLOFaxApp: public KUniqueApplication
{
public:
	KMLOFaxApp();
	virtual ~KMLOFaxApp();

	void addPreview(Preview *p);
	void removePreview(Preview *p);

	Preview *getPreview();

	virtual bool x11EventFilter(XEvent *ev);

private:
	QPtrList<Preview> previews;
};



class KMLOFax: public KMainWindow
{
	Q_OBJECT
public:
	KMLOFax(QWidget *parent = 0, const char *name = 0);
	virtual ~KMLOFax();

protected:
	void initActions();
	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	void initWhatsThis();

public slots:
	void readOptions();
	void saveOptions();
	
	void commandCallback(int id_);

	void slotFileDownload();
	void slotFileView();
	void slotFilePrint();
	void slotFileExport();
	void slotFileMail();
	void slotFileTrash();
	void slotFileSenderAlias();
	void slotFileRebuildDir();
	void slotFileQuit();

	void slotFolderNew();
	void slotFolderRename();
	void slotFolderEmpty();
	void slotFolderRemove();

	void slotSettingsShowToolbar();
	void slotSettingsShowStatusbar();
	void slotSettingsConfigure();
	void slotSettingsSenderAliases();

	void slotStatusMsg(const QString &text);
	void slotStatusHelpMsg(const QString &text);

private slots:
	void hasCurrentFolderSlot(bool isRoot, bool isUser);
	void hasCurrentFaxSlot(bool on);
	void fetchFile(const QString &name);
	void fetchDone();

private:
	KConfig *config;

	KAction *fileDownload, *fileView, *filePrint, *fileExport, *fileMail;
	KAction *fileTrash, *fileSenderAlias, *fileQuit;
	KAction *folderNew, *folderRename, *folderEmpty, *folderRemove;
	KToggleAction *settingsShowToolbar, *settingsShowStatusbar;
	KAction *settingsSaveOptions, *settingsSenderAliases, *settingsConfigure;

	FaxFiler *view;
	MLOLoader *loader;

	StatusProgress *progress;

	KProcess proc;
};

#endif // KMLOFAX_H 
