/***************************************************************************
                          kliste.cpp  -  description
                             -------------------
    begin                : Die Aug 17 03:44:15 CEST 1999

    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qwhatsthis.h>
//#include <iostream.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <qevent.h>

#include <noteoverview.h>

// application specific includes
#include <kliste.h>
#include "bibtexfile.h"
#include "resource.h"
#include "author.h"
#include "note.h"
#include "selection.h"
#include "publication.h"
#include "bibliography.h"
#include "publisher.h"
#include "journalview.h"
#include "part.h"
#include "partmemo.h"
#include "dataview.h"
#include "authorselect.h"
#include "noteselect.h"
#include "publselect.h"
#include "backgrseldlg.h"
#include "search.h"
#include "state.h"
#include "export.h"
#include "publisherselect.h"
#include "journalselect.h"
#include <sys/types.h>
#include <sys/time.h>
#include <kstdaction.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include "processfiledlg.h"
#include "mimetypes.h"
#include <kstatusbar.h>

/***********************/

KaspaComboAction::KaspaComboAction( const QString& text, int accel,
                                    const QObject *act_recv, const char *act_slot,
                                    const QObject *txt_snd, const char *txt_sig,
                                    const QObject *his_snd, const char *his_sig,
                                    QObject* parent, const char* name )
    : KAction( text, accel, parent, name )
{
  combo=0L;
  act_receiver = act_recv;
  act_member = act_slot;
  txt_sender = txt_snd;
  txt_member = txt_sig;
  his_sender = his_snd;
  his_member = his_sig;

}

KaspaComboAction::~KaspaComboAction()
{
}

int KaspaComboAction::plug( QWidget *w, int index )
{

  KToolBar *toolBar = dynamic_cast<KToolBar *>(w);

  combo = new QComboBox( toolBar, "history combo" );
  combo->setEditable(true);
  connect( combo, SIGNAL(activated(const QString&)), act_receiver, act_member );
  connect( txt_sender, txt_member, combo, SLOT(setEditText(const QString&)) );
  connect( his_sender, his_member, this, SLOT(slotAddHistory(const QString&)) );
  connect( toolBar, SIGNAL(destroyed()), this, SLOT( slotDestroyed() ) );
  QWhatsThis::add( combo, whatsThis() );

  int id = KAction::getToolButtonID();
  toolBar->insertWidget( id, 70, combo, index );
  addContainer( toolBar, id );
  toolBar->setItemAutoSized( id, true );
  emit plugged();

  return containerCount() - 1;
}

void KaspaComboAction::unplug( QWidget *w )
{
  KToolBar *toolBar = (KToolBar *)w;

  int idx = findContainer( w );
  toolBar->removeItem( menuId( idx ) );
  removeContainer( idx );
}

void KaspaComboAction::slotAddHistory(const QString& s) {
  if(combo) combo->insertItem(s, 0);
}

/***********************/

bool cancelRequested=false;

bool idle(void) {
  struct timeval timeout;
  timeout.tv_sec = 0;
  timeout.tv_usec = 50;
	select (0L, 0L, 0L, 0L, &timeout);
	kapp->processEvents();
	bool c=cancelRequested;
	cancelRequested=false;
	return !c;
};

#define HANDLE_CATCH(err) err.print(); \
													QMessageBox::warning(this, i18n("Error"), err.error()); \
													slotInvalidGUI(); \
													delete view; \
										  	  view=0;

KaspalisteApp::KaspalisteApp(QString dbname): config(0L), view(0L)
{
	init(dbname);
	initBackForward();
}

KaspalisteApp::KaspalisteApp(QKaspaEvent *e, QString dbname): config(0L), view(0L)
{
		init(dbname);
	  kapp->postEvent(this, e);
}

void KaspalisteApp::init(QString dbname) {
	tbdock=QMainWindow::Left;
  setXMLFile("kaspalisteui.rc");
  initAction();
  currenttools=0L;
  createGUI(0L);
  db=dbname;

	try {
    conn=new Sql(dbname);
  }  catch (SqlConnectionErr) {
		// Start postgres
		throw;
  }

  config=KGlobal::config();

  initToolBar();
  initStatusBar();

//  initKeyAccel();

  forward.setAutoDelete(false);
  back.setAutoDelete(false);

  readOptions();
	setupWallpapers();
  setAutoSaveSettings();
}

KaspalisteApp::~KaspalisteApp()
{
//  cout << "\ntoolbar pos=" << toolBar("mainToolBar")->barPos()<<"\n";
  saveMainWindowSettings(kapp->sessionConfig());
  delete view;
	view=0;
  delete conn;
}

void KaspalisteApp::initBackForward()  {
  back.clear();
  forward.clear();
  config->setGroup("EventStackBack");
  int count=config->readNumEntry("Count");
  for(int i=count-1; i>=0; i--) {
  	QKaspaEvent *e=new QKaspaEvent();
  	QString s("Url"); s+=QString().setNum(i);
  	e->setUrl(config->readEntry(s));
	  back.append(e);
	}
  config->setGroup("EventStackForward");
  count=config->readNumEntry("Count");
  for(int i=count-1; i>=0; i--) {
  	QKaspaEvent *e=new QKaspaEvent();
  	QString s("Url"); s+=QString().setNum(i);
  	e->setUrl(config->readEntry(s));
	  forward.append(e);
	}

	config->setGroup("CurrentEvent");
	QKaspaEvent *e=new QKaspaEvent(config->readEntry("Url"));
	kapp->postEvent(this, e);
}


void KaspalisteApp::initAction()
{

  actCopy  = KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection(), "edit");
  actCut   = KStdAction::cut(this, SLOT(slotEditCut()), actionCollection(), "cut");
  actPaste = KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection(), "paste");
  actClose = KStdAction::close(this, SLOT(slotClose()), actionCollection(), "close");
  actQuit  = KStdAction::quit(kapp, SLOT(closeAllWindows()), actionCollection(), "quit");
  connect( kapp, SIGNAL( lastWindowClosed() ), kapp, SLOT( quit() ) );

  actCreateBibTex = new KAction( "Create BibTex", 0, this, SLOT(slotCreateBibTex()), actionCollection(), "create_bibtex");
  actExport = new KAction( "Export", 0, this, SLOT(slotExport()), actionCollection(), "export");

  actAuthorOverview = new KAction( "Author Overview", "showauthor", 0, this, SLOT(slotAuthorOverview()), actionCollection(), "author_overview");
  actNoteOverview = new KAction( "Note Overview", "shownote", 0, this, SLOT(slotNoteOverview()),  actionCollection(), "note_overview");
  actPublOverview = new KAction( "Publication Overview", "showpubl", 0, this, SLOT(slotPublOverview()), actionCollection(), "publ_overview");
  actPublisherOverview = new KAction( "Publisher Overview", "showpublisher", 0, this, SLOT(slotPublisherOverview()), actionCollection(), "publisher_overview");
  actJournalOverview = new KAction( "Journal Overview", "showjournal", 0, this, SLOT(slotJournalOverview()), actionCollection(), "journal_overview");
  actState = new KAction( "State", "state", 0, this, SLOT(slotState()), actionCollection(), "state");

  actNewAuthor = new KAction( "New Author", "newauthor", 0, this, SLOT(slotNewAuthor()), actionCollection(), "new_author");
  actNewNote   = new KAction( "New Note", "newnote", 0, this, SLOT(slotNewNote()),  actionCollection(), "new_note");
  actNewPublication = new KAction( "New Publication", "newpubl", 0, this, SLOT(slotNewPublication()), actionCollection(), "new_publication");
  actNewPublisher   = new KAction( "New Publisher", "newpublisher", 0, this, SLOT(slotNewPublisher()), actionCollection(), "new_publisher");
  actNewJournal   = new KAction( "New Journal", "newjournal", 0, this, SLOT(slotNewJournal()), actionCollection(), "new_journal");

  actSearch     = new KAction( "Search", "search", 0, this, SLOT(slotSearch()), actionCollection(), "start_search");

  actOptionBackground = new KAction( "Background", 0, this, SLOT(slotChooseBackground()), actionCollection(), "options_background");
  actOptionMimeTypes = new KAction( "Setup MimeTypes", 0, this, SLOT(slotMimeTypes()), actionCollection(), "mimetypes");
  actOptionKeys = KStdAction::keyBindings(this, SLOT(slotConfigureKeys()), actionCollection(), "configure_keys");

  actOptionToolbar  = KStdAction::configureToolbars(this, SLOT(slotConfigureToolbar()), actionCollection(), "configure_toolbar");

  actRebuildText = new KAction( "Rebuild Text", 0, this, SLOT(slotRebuildText()), actionCollection(), "rebuild_text");

  actNewWindow = new KAction( "New Window", 0, this, SLOT(slotNewWindow()), actionCollection(), "new_window");
  actMainToolBar   = new KToggleAction( "Show Main Toolbar", 0, this, SLOT(slotViewMainToolBar()),  actionCollection(), "show_main_toolbar");
  actNavToolBar   = new KToggleAction( "Show Navigation Toolbar", 0, this, SLOT(slotViewNavToolBar()),  actionCollection(), "show_nav_toolbar");
  actStatusBar = new KToggleAction( "Show Statusbar", 0, this, SLOT(slotViewStatusBar()), actionCollection(), "show_statusbar");
  actBack    = new KAction( "Back", "back.png", 0, this, SLOT(slotBack()),  actionCollection(), "back");
  actForward = new KAction( "Forward", "forward.png", 0, this, SLOT(slotForward()), actionCollection(), "forward");

  actBack->setEnabled(false);
  actForward->setEnabled(false);

  actURLCombo = new KaspaComboAction("URL", 0, this, SLOT(slotSetToolbarURL(const QString&)),
                                     this, SIGNAL(setURLText(const QString&)),
                                     this, SIGNAL(addURL(const QString&)), actionCollection(), "url_combo");
}

void KaspalisteApp::initToolBar()
{
  if(statusBar() && statusBar()->isVisible())
 		actStatusBar->setChecked(true);
  else
 		actStatusBar->setChecked(false);

  if(toolBar("navToolbar") && toolBar("navToolbar")->isVisible())
 		actNavToolBar->setChecked(true);
  else
 		actNavToolBar->setChecked(false);

  if(toolBar("mainToolbar") && toolBar("mainToolbar")->isVisible())
 		actMainToolBar->setChecked(true);
  else
 		actMainToolBar->setChecked(false);

  setDockEnabled(QMainWindow::Top, true);
  setDockEnabled(QMainWindow::Left, true);
  setDockEnabled(QMainWindow::Right, true);
  setDockEnabled(QMainWindow::Bottom, true);


/*
 	toolBar()->insertLined("", ID_URLLINE, SIGNAL(returnPressed()), this, SLOT(slotSetToolbarURL()));
 	urlline=toolBar()->getLined(ID_URLLINE);
	QWhatsThis::add(urlline,	i18n("Kaspaliste works like a browser. The different views behave like documents " \
																 "and they take a where clause formulated in sql as a parameter. " \
																 "The where clause applies to the underlying database table. This is a very " \
																 "flexible feature. Some knowledge about the database structure is required but it " \
																 "allows quite complex queries. The table structure can be found in the create.tables.sql " \
																 "file in the kaspaliste distribution.\n" \
																 "The name of the view is followed by a '#' for the where clause or a '?' for a " \
																 "a command. A command is for example 'new'. The url 'kaspa://publication?new' " \
																 "creates a new publication.")); 	
	connect(urlline, SIGNAL(completion(void)),SLOT(slotNextFocus(void)));
	toolBar()->setItemAutoSized(ID_URLLINE);
*/
}

void KaspalisteApp::initStatusBar()
{
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG );
}


void KaspalisteApp::slotEnableCommand(int id_)
{
/*
  menuBar()->setItemEnabled(id_,true);
	toolBar()->setItemEnabled(id_,true);
*/
	if(currenttools) currenttools->setItemEnabled(id_,true);
}

void KaspalisteApp::slotDisableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
/*
  menuBar()->setItemEnabled(id_,false);
	toolBar()->setItemEnabled(id_,false);
*/
	if(currenttools) currenttools->setItemEnabled(id_,false);
}


void KaspalisteApp::slotChooseBackground() {
  ///////////////////////////////////////////////////////////////////
  // Choose Wallpapers
	BackgrSelDlg dlg(this, "choosebackgrdlg");
	dlg.setAuthor(authorbackgrpath);
	dlg.setPubl(selbackgrpath);
	dlg.setPart(partbackgrpath);
	dlg.setPartMemo(partmemobackgrpath);
	dlg.setNote(notebackgrpath);
	dlg.setHTML(htmlbackgrpath);
	dlg.setBiblio(bibliobackgrpath);
	dlg.setPublisher(publisherbackgrpath);
	dlg.setSelect(selbackgrpath);
	dlg.setSearch(searchbackgrpath);
	if(dlg.exec()) {
		authorbackgrpath=dlg.getAuthor();
		partbackgrpath=dlg.getPart();
		partmemobackgrpath=dlg.getPartMemo();
		publbackgrpath=dlg.getPubl();
		publisherbackgrpath=dlg.getPublisher();
		bibliobackgrpath=dlg.getBiblio();
		htmlbackgrpath=dlg.getHTML();
		notebackgrpath=dlg.getNote();
		selbackgrpath=dlg.getSelect();
		searchbackgrpath=dlg.getSearch();
		setupWallpapers();
	}
}

void KaspalisteApp::setupWallpapers() {
		authorbackgr.load(authorbackgrpath);
		partbackgr.load(partbackgrpath);
		partmemobackgr.load(partmemobackgrpath);
		publbackgr.load(publbackgrpath);
		publisherbackgr.load(publisherbackgrpath);
		bibliobackgr.load(bibliobackgrpath);
		htmlbackgr.load(htmlbackgrpath);
		notebackgr.load(notebackgrpath);
		selbackgr.load(selbackgrpath);
		searchbackgr.load(searchbackgrpath);
}



void KaspalisteApp::saveOptions()
{	
	if(!config) return;
  config->setGroup("General Options");
//  config->writeEntry("Geometry", size() );
//  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
//  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
//  config->writeEntry("ToolBarPos",  (int)toolBar()->barPos());
  config->writeEntry("CustomToolBarPos",  (int)tbdock);

  config->writeEntry("AuthorWallpaper", authorbackgrpath);
  config->writeEntry("PartWallpaper", partbackgrpath);
  config->writeEntry("PartMemoWallpaper", partmemobackgrpath);
  config->writeEntry("PublicationWallpaper", publbackgrpath);
  config->writeEntry("SelectionWallpaper", selbackgrpath);
  config->writeEntry("NoteWallpaper", notebackgrpath);
  config->writeEntry("HTMLWallpaper", htmlbackgrpath);
  config->writeEntry("BiblioWallpaper", bibliobackgrpath);
  config->writeEntry("PublisherWallpaper", publisherbackgrpath);
	config->writeEntry("SearchWallpaper", searchbackgrpath);

  config->setGroup("EventStackBack");
  int c=back.count()<=10?back.count():10;
  config->writeEntry("Count", c);
  for(int i=0; i<c; i++) {
  	QKaspaEvent *e=back.getLast();
  	back.removeLast();
	  QString s("Url"); s+=QString().setNum(i);
	  config->writeEntry(s, (const char*) e->url());
	  delete e;
	}
  config->setGroup("EventStackForward");
  c=forward.count()<=10?forward.count():10;
  config->writeEntry("Count", c);
  for(int i=0; i<c; i++) {
  	QKaspaEvent *e=forward.getLast();
  	forward.removeLast();
	  QString s("Url"); s+=QString().setNum(i);
	  config->writeEntry(s, (const char*) e->url());
	  delete e;
	}

	config->setGroup("CurrentEvent");
	if(view && view->getState()==INVALID)
		config->writeEntry("Url", "kaspa://overview");
	else
		config->writeEntry("Url", view?view->url():"kaspa://overview");
}


void KaspalisteApp::readOptions()
{
  config->setGroup("General Options");

  // bar status settings
  /*
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  if(!bViewToolbar && toolBar())
    toolBar()->hide();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  if(!bViewStatusbar && statusBar()) {
    statusBar()->hide();
 		actStatusBar->setChecked(false);
 	}
 	else {
    statusBar()->show();
 		actStatusBar->setChecked(true);
	}

  // bar position settings
  KToolBar::BarPosition tool_bar_pos;
  tool_bar_pos=(KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

  toolBar()->setBarPos(tool_bar_pos);
  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
    resize(size);
  */
	tbdock=QMainWindow::ToolBarDock(config->readNumEntry("CustomToolBarPos", QMainWindow::Left));
  if(tbdock!=QMainWindow::Left && tbdock!=QMainWindow::Right &&
     tbdock!=QMainWindow::Top && tbdock!=QMainWindow::Bottom)
  tbdock=QMainWindow::Left;

	// Wallpapers
  authorbackgrpath=config->readEntry("AuthorWallpaper");
  partbackgrpath=config->readEntry("PartWallpaper");
  partmemobackgrpath=config->readEntry("PartMemoWallpaper");
  publbackgrpath=config->readEntry("PublicationWallpaper");
  selbackgrpath=config->readEntry("SelectionWallpaper");
  notebackgrpath=config->readEntry("NoteWallpaper");
  htmlbackgrpath=config->readEntry("HTMLWallpaper");
  bibliobackgrpath=config->readEntry("BiblioWallpaper");
  publisherbackgrpath=config->readEntry("PublisherWallpaper");
	searchbackgrpath=config->readEntry("SearchWallpaper");
 }

void KaspalisteApp::saveProperties(KConfig* )
{
}

void KaspalisteApp::readProperties(KConfig*)
{
}		

bool KaspalisteApp::queryClose()
{	
  return view ? view->close() : true;
}

bool KaspalisteApp::queryExit()
{
  saveOptions();
  return true;
}

bool KaspalisteApp::cleanupView() {

	if(view&&!view->close()) return false;
	else {
		delete view;
		view=0;
	}

	return true;
}

void KaspalisteApp::setupView(const QPixmap &pm) {
	ASSERT(view);
	int i;
	bool n;
	int j;
	if(currenttools) {
	  getLocation(currenttools, tbdock, i, n, j);
		delete currenttools; currenttools=0;
	}
	
	menuBar()->setUpdatesEnabled(false);
  if(!pm.isNull())
    view->setBackgroundPixmap(pm);
	kaspaConnections(view);
	setCentralWidget(view);

	currenttools=view->getToolBar();
  if(currenttools)
//		addToolBar(currenttools);
		addToolBar(currenttools, tbdock);

	menuBar()->setUpdatesEnabled(true);

	menuBar()->repaint();
	view->show();
  view->setFocus();
	view->setFields();

	if(currenttools) {
    moveToolBar(currenttools, tbdock);
    currenttools->show();
  }
}

////////////////////////////////////////////////////////////////////
//  build up views...
////////////////////////////////////////////////////////////////////

void KaspalisteApp::slotAuthorOverview() {
  slotSetURL("kaspa://authoroverview#order by lastname", false);
}

void KaspalisteApp::slotNoteOverview() {
  slotSetURL("kaspa://noteoverview#where type=0 order by title", false);
}

void KaspalisteApp::slotPublOverview() {
  slotSetURL("kaspa://publicationoverview#order by title", false);
}

void KaspalisteApp::slotPublisherOverview() {
  slotSetURL("kaspa://publisheroverview#order by name", false);
}

void KaspalisteApp::slotJournalOverview() {
  slotSetURL("kaspa://journaloverview#order by serie", false);
}

void KaspalisteApp::slotNewAuthor() {
  slotSetURL("kaspa://author?new", false);
}

void KaspalisteApp::slotNewNote() {
  slotSetURL("kaspa://note?new", false);
}

void KaspalisteApp::slotNewPublication() {
  slotSetURL("kaspa://publication?new", false);
}

void KaspalisteApp::slotNewPublisher() {
  slotSetURL("kaspa://publisher?new", false);
}

void KaspalisteApp::slotNewJournal() {
  slotSetURL("kaspa://journal?new", false);
}


void KaspalisteApp::slotSearch() {
  slotSetURL("kaspa://search", false);
}

void KaspalisteApp::slotState() {
  slotSetURL("kaspa://state", false);
}

bool KaspalisteApp::showAuthorOverview(KaspaURL url, const char *caption) {
  try {
		if(!cleanupView()) return false;
    emit setCaption(i18n("Author Overview"));
    view = new AuthorSelect(url, conn, caption?caption:"Authors", this);
		setupView(selbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showPublisherOverview(KaspaURL url, const char *caption) {
  try {
		if(!cleanupView()) return false;
    emit setCaption(i18n("Publisher Overview"));
    view = new PublisherSelect(url, conn, caption?caption:"Publisher", this);
		setupView(selbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showJournalOverview(KaspaURL url, const char *caption) {
  try {
		if(!cleanupView()) return false;
    emit setCaption(i18n("Journal Overview"));
    view = new JournalSelect(url, conn, caption?caption:"Journal", this);
		setupView(selbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showPublOverview(KaspaURL url, const char *caption) {
  try {
		if(!cleanupView()) return false;
    emit setCaption(i18n("Publication Overview"));
    view = new PublSelect(url, conn, caption?caption:"Publications", this);
		setupView(selbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showNoteOverview(KaspaURL url, const char *caption) {
  try {
		if(!cleanupView()) return false;
    emit setCaption(i18n("Note Overview"));
    view = new NoteOverview(url, conn, caption?caption:"Links", this);
		setupView(selbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;

}

bool KaspalisteApp::showAuthor(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Author(url, conn, this, "Author");
		setupView(authorbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showPart(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Part(url, conn, this, "Part");
		setupView(partbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showPublication(KaspaURL url) {
  try {
//		debug("KaspalisteApp::showPublication() - url=%s", (const char *) url);
		
		if(!cleanupView()) return false;
    view = new Publication(url, conn, this, "Publication");
		setupView(publbackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showPartMemo(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new PartMemo(url, conn, this, "PartMemo");
		setupView(partmemobackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showBibliography(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Bibliography(url, conn, this, "Bibliography");
		setupView(bibliobackgr);
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showNote(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Note(url, conn, this, "Note");
		setupView(notebackgr);
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showDataView(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new DataView(url, conn, this, "Data");
		setupView(htmlbackgr);
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showPublisher(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new Publisher(url, conn, this, "Publisher");
		setupView(publisherbackgr);
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}

bool KaspalisteApp::showJournal(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    view = new JournalView(url, conn, this, "Journal");
		setupView(publisherbackgr);
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showSearch(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    emit setCaption(i18n("Search"));
    view = new Search(url, conn, this, "Search");
		setupView(searchbackgr); // <-- another Background???
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}


bool KaspalisteApp::showState(KaspaURL url) {
  try {
		if(!cleanupView()) return false;
    emit setCaption(i18n("State"));
    view = new State(url, conn, this, "State");
		setupView(QPixmap());
  }  catch(KaspaErr& err) {
		HANDLE_CATCH(err);
		return false;
  }
  return true;
}



///////////////////////////////////////////////////////////////
// event handling
//////////////////////////////////////////////////////////////
bool KaspalisteApp::event(QEvent *e) {
	//	debug("KaspalisteApp::event()");
	if(e->type()==QEvent::User) {
		QKaspaEvent *k=static_cast<QKaspaEvent*>(e);
		ASSERT(e);
		KaspaURL url(k->url());
//		debug("KaspalisteApp::event(QEvent*) - url=%s", (const char *)url);
//		debug("KaspalisteApp::event(QEvent*) - table=%s", (const char *)url.table());
    if(!strcmp(url.table(), "author")) showAuthor(url);
		else if(!strcmp(url.table(), "publication")) showPublication(url);
    else if(!strcmp(url.table(), "publisher")) showPublisher(url);
    else if(!strcmp(url.table(), "journal")) showJournal(url);
		else if(!strcmp(url.table(), "bibliography")) showBibliography(url);
		else if(!strcmp(url.table(), "partmemo")) showPartMemo(url);
		else if(!strcmp(url.table(), "part")) showPart(url);
		else if(!strcmp(url.table(), "partdata")) showDataView(url);
		else if(!strcmp(url.table(), "authoroverview")) showAuthorOverview(url, "Author Overview");
    else if(!strcmp(url.table(), "note")) showNote(url);
		else if(!strcmp(url.table(), "noteoverview")) showNoteOverview(url, "Note Overview");
    else if(!strcmp(url.table(), "publicationoverview")) showPublOverview(url, "Publication Overview");
    else if(!strcmp(url.table(), "publisheroverview")) showPublisherOverview(url, "Publisher Overview");
    else if(!strcmp(url.table(), "journaloverview")) showJournalOverview(url, "Journal Overview");
    else if(!strcmp(url.table(), "search")) showSearch(url);
    else {
      url="kaspa://state";
      showState(url);
    }
    // if(!strcmp(url.table(), "state")) showState(url);

		emit setURLText(url);
		emit addURL(url);
		setupBackForward();
    return true;
  }	
  return MainWindow::event(e);			
}				

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KaspalisteApp::setupBackForward() {
  if(back.count()<1 || (view && view->getState()==WORKING))
    actBack->setEnabled(false);
  else
    actBack->setEnabled(true);

  if(forward.isEmpty() || (view && view->getState()==WORKING))
	  actForward->setEnabled(false);
	else
    actForward->setEnabled(true);
}

void KaspalisteApp::slotNextFocus() {
	focusNextPrevChild(true);
}

void KaspalisteApp::slotBack() {
//  qDebug("\nKaspalisteApp::slotBack() - count back=%i", back.count());
	if(view && view->getState()!=INVALID)
		forward.append(new QKaspaEvent(view->url(), view->caption()));
  QEvent *ev= back.getLast();
  if(ev)
    kapp->postEvent(this, ev);
  back.removeLast();
	setupBackForward();
}

void KaspalisteApp::slotForward() {
	if(view && view->getState()!=INVALID)
		back.append(new QKaspaEvent(view->url(), view->caption()));
  kapp->postEvent(this, forward.getLast());
  forward.removeLast();
	setupBackForward();
}	


void KaspalisteApp::slotSetURL(const char *url, bool newwin) {
	slotSetURL(url, newwin, "");
}

void KaspalisteApp::slotSetURL(const char *url, bool newwin, const char *caption) {
	if(!newwin && view && view->getState()!=INVALID)
		back.append(new QKaspaEvent(view->url(), view->caption()));

	QKaspaEvent *e = new QKaspaEvent();
	e->setUrl(url);
	e->setCaption(caption);
	if(newwin) {
		KaspalisteApp* new_window= new KaspalisteApp(e, db);
		new_window->show();
	}
	else {
		kapp->postEvent(this, e);
		forward.clear();
		slotDisableCommand(ID_FORWARD);
	}
}

void KaspalisteApp::slotNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));

  KaspalisteApp* new_window=new KaspalisteApp(db);
  new_window->show();
}


void KaspalisteApp::slotClose()
{
  slotStatusMsg(i18n("Closing file..."));
  close();
}

void KaspalisteApp::slotPrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this)){
    //			view->print(&printer);
  }

}

void KaspalisteApp::slotMimeTypes() {
  MimeTypes dlg(this);
  dlg.exec();
}

void KaspalisteApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));
  if(view) view->cut();
}

void KaspalisteApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to Clipboard..."));
  if(view) view->copy();
}

void KaspalisteApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting Clipboard contents..."));
  if(view) view->paste();
}

void KaspalisteApp::slotViewMainToolBar()
{
  slotViewToolBar("mainToolbar");
}

void KaspalisteApp::slotViewNavToolBar()
{
  slotViewToolBar("navToolbar");
}

void KaspalisteApp::slotViewToolBar(QString tb)
{
  KToolBar *t=toolBar(tb);
  if(!t) return;
  if(t->isVisible())
    t->hide();
   else
    t->show();
}

void KaspalisteApp::slotViewStatusBar()
{
  if(statusBar() && statusBar()->isVisible()) {
		statusBar()->hide();
		actStatusBar->setChecked(false);
  }
  else {
		statusBar()->show();
		actStatusBar->setChecked(true);
  }
}


void KaspalisteApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KaspalisteApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void KaspalisteApp::slotSetCaption(const char *text) {
  setCaption(text);
}

void KaspalisteApp::slotSetToolbarURL(const QString& url) {
	slotSetURL(url, false);
}

void KaspalisteApp::slotInvalidGUI() {
  actCopy->setEnabled(true);
	actCut->setEnabled(true);
	actPaste->setEnabled(false);
	actClose->setEnabled(true);
	actQuit->setEnabled(true);
	
	actCreateBibTex->setEnabled(true);
	actExport->setEnabled(true);
	actAuthorOverview->setEnabled(true);
	actNoteOverview->setEnabled(true);
	actPublOverview->setEnabled(true);
	actPublisherOverview->setEnabled(true);
	actJournalOverview->setEnabled(true);
	actNewAuthor->setEnabled(true);
	actNewNote->setEnabled(true);
	actNewPublication->setEnabled(true);
	actNewPublisher->setEnabled(true);
	actNewJournal->setEnabled(true);
	actSearch->setEnabled(true);
	actState->setEnabled(true);
	actOptionBackground->setEnabled(true);
	actOptionKeys->setEnabled(true);
	actOptionToolbar->setEnabled(true);
	actNewWindow->setEnabled(true);
	actNavToolBar->setEnabled(true);
	actMainToolBar->setEnabled(true);
	actStatusBar->setEnabled(true);
  actRebuildText->setEnabled(true);	

//	urlline->setEnabled(true);
	slotStatusMsg(i18n("Invalid!"));
	setupBackForward();
}

void KaspalisteApp::slotWorkingGUI() {
  actCopy->setEnabled(true);
	actCut->setEnabled(true);
	actPaste->setEnabled(true);
	actClose->setEnabled(false);
	actQuit->setEnabled(false);

	actCreateBibTex->setEnabled(false);
	actExport->setEnabled(false);
	actAuthorOverview->setEnabled(false);
	actNoteOverview->setEnabled(false);
	actPublOverview->setEnabled(false);
	actPublisherOverview->setEnabled(false);
	actJournalOverview->setEnabled(false);	
	actNewAuthor->setEnabled(false);
	actNewNote->setEnabled(false);
	actNewPublication->setEnabled(false);
	actNewPublisher->setEnabled(false);
	actNewJournal->setEnabled(false);
	actSearch->setEnabled(false);
	actState->setEnabled(false);
	actOptionBackground->setEnabled(false);
	actOptionKeys->setEnabled(false);
	actOptionToolbar->setEnabled(false);
	actNewWindow->setEnabled(true);
	actNavToolBar->setEnabled(false);
	actMainToolBar->setEnabled(false);
	actStatusBar->setEnabled(false);
  actRebuildText->setEnabled(false);

//	urlline->setEnabled(false);
	slotStatusMsg(i18n("Working..."));
	setupBackForward();
}

void KaspalisteApp::slotReadWriteGUI() {
  actCopy->setEnabled(true);
	actCut->setEnabled(true);
	actPaste->setEnabled(true);
	actClose->setEnabled(true);
	actQuit->setEnabled(true);
	
	actCreateBibTex->setEnabled(true);
	actExport->setEnabled(true);
	actAuthorOverview->setEnabled(true);
	actNoteOverview->setEnabled(true);
	actPublOverview->setEnabled(true);
	actPublisherOverview->setEnabled(true);
	actJournalOverview->setEnabled(true);	
	actNewAuthor->setEnabled(true);
	actNewNote->setEnabled(true);
	actNewPublication->setEnabled(true);
	actNewPublisher->setEnabled(true);
	actNewJournal->setEnabled(true);
	actSearch->setEnabled(true);
	actState->setEnabled(true);
	actOptionBackground->setEnabled(true);
	actOptionKeys->setEnabled(true);
	actOptionToolbar->setEnabled(true);
	actNewWindow->setEnabled(true);
	actNavToolBar->setEnabled(true);
	actMainToolBar->setEnabled(true);
	actStatusBar->setEnabled(true);
  actRebuildText->setEnabled(true);

//	urlline->setEnabled(true);
	slotStatusMsg(i18n("Ready..."));
	setupBackForward();
}

void KaspalisteApp::slotReadOnlyGUI() {
  actCopy->setEnabled(true);
	actCut->setEnabled(true);
	actPaste->setEnabled(false);
	actClose->setEnabled(true);
	actQuit->setEnabled(true);
	
	actCreateBibTex->setEnabled(true);
	actExport->setEnabled(true);
	actAuthorOverview->setEnabled(true);
	actNoteOverview->setEnabled(true);
	actPublOverview->setEnabled(true);
	actPublisherOverview->setEnabled(true);
	actJournalOverview->setEnabled(true);
	actNewAuthor->setEnabled(true);
	actNewNote->setEnabled(true);
	actNewPublication->setEnabled(true);
	actNewPublisher->setEnabled(true);
	actNewJournal->setEnabled(true);
	actSearch->setEnabled(true);
	actState->setEnabled(true);
	actOptionBackground->setEnabled(true);
	actOptionKeys->setEnabled(true);
	actOptionToolbar->setEnabled(true);
	actNewWindow->setEnabled(true);
	actNavToolBar->setEnabled(true);
	actMainToolBar->setEnabled(true);
	actStatusBar->setEnabled(true);
  actRebuildText->setEnabled(true);

//	urlline->setEnabled(true);
	slotStatusMsg(i18n("Read-Only..."));
	setupBackForward();
}


void KaspalisteApp::kaspaConnections(KaspaWidget *w) {
	connect(w, SIGNAL(setCaption(const char*)), SLOT(slotSetCaption(const char *)));
	connect(w, SIGNAL(statusMessage(const char*)), SLOT(slotStatusHelpMsg(const char *)));
	connect(w, SIGNAL(enableCommand(int)), SLOT(slotEnableCommand(int)));
	connect(w, SIGNAL(enableCommand(int,bool)), SLOT(slotEnableCommand(int,bool)));
	connect(w, SIGNAL(disableCommand(int)), SLOT(slotDisableCommand(int)));
	connect(w, SIGNAL(requestURL(const char *,bool)), SLOT(slotSetURL(const char *,bool)));
	connect(w, SIGNAL(requestURL(const char *,bool, const char *)),
						 SLOT(slotSetURL(const char *, bool, const char *)));
  connect(w, SIGNAL(workingGUI()), SLOT(slotWorkingGUI()));
  connect(w, SIGNAL(invalidGUI()), SLOT(slotInvalidGUI()));
  connect(w, SIGNAL(readOnlyGUI()), SLOT(slotReadOnlyGUI()));
  connect(w, SIGNAL(readWriteGUI()), SLOT(slotReadWriteGUI()));

  connect(w, SIGNAL(modifyGUI(KParts::Part *)), SLOT(slotCreateGUI(KParts::Part *)));
}

void KaspalisteApp::slotCreateGUI(KParts::Part *part) {
//  cout << "slotCreateGUI()\n";
  createGUI(part);
}

void KaspalisteApp::slotCreateBibTex() {
	try {
		if(view) view->flush();
		BibTexFile b;
		b.exec();
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
  }
}

void KaspalisteApp::slotExport() {
	try {
 		Export e;
		e.exec();
  } catch(KaspaErr& err) {
		HANDLE_CATCH(err);
  }
}

void KaspalisteApp::slotConfigureKeys() {
 KKeyDialog::configureKeys(actionCollection(), xmlFile());
}

void KaspalisteApp::slotConfigureToolbar() {
 saveMainWindowSettings( KGlobal::config(), "MainWindow" );
// KEditToolbar dlg(actionCollection());

 KEditToolbar dlg(factory());
 connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(slotNewToolbarConfig()));
 dlg.exec();

// if(dlg.exec()) createGUI(0L);
}

void KaspalisteApp::slotNewToolbarConfig() {
//    ...if you use any action list, use plugActionList on each here...
  applyMainWindowSettings( KGlobal::config(), "MainWindow" );
}


void KaspalisteApp::slotRebuildText() {
  int a=KMessageBox::warningYesNoCancel(this, "Rebuild the index?", "Rebuild Index",
                                           i18n("Rebuild all"), i18n("Rebuild empty"));
  if(a==KMessageBox::Cancel)
    return;
  try {
    ProcessFileDlg dlg(conn, this, "ProcessFilesDlg");
    dlg.show();
    dlg.slotRebuildText(a==KMessageBox::Yes);
  } catch(KaspaErr& err) {
    KMessageBox::error(this, err.error());
  }
}
