// -*-Mode: C++;-*-
/*
   $Id: PatternPair.h,v 2.6 2000/09/06 00:03:43 ral Exp $
   Include file for the CPatternPair class
*/

#include <string>
#include <vector>

#ifndef PatternPair_inc
#define PatternPair_inc

//! Patterndescriptor
/*!
    This class descripes a pair of pattern, which will be a assignement.
    i.e, a=1 will result in a CPatternPair with entry = 'a' and pattern = '1'.
    It can be used to assign a variable name to a value.
*/
class CPatternPair
{
protected:
    std::string entry;
    std::string pattern;
    bool password_entry;
    bool numeric_entry;
    bool large_text;
    virtual void copy_old(const CPatternPair&old);

public:
    //! Constructor
    /*!
      constructs a CPatternPair, setting entry to Entry and pattern to Pattern
      \param Entry the entry-name
      \param Pattern the pattern which is assigned with the entry
      \sa CPatternPair(const CPatternPair& old)
    */
    CPatternPair(const char*Entry,const char*Pattern);
    CPatternPair(const std::string&Entry,const std::string&Pattern);
    CPatternPair(){password_entry=false;numeric_entry=false;large_text=false;}
    //! copy constructor
    /*!
      this is the copy constructor of CPatternPair.
      all values of \c old are stored in a resulting copy
      \param old object to be copied
    */
    CPatternPair(const CPatternPair& old);
    CPatternPair&operator=(const CPatternPair&old);
    //! Destructor
    virtual ~CPatternPair(){};
    //! The entry
    /*! 
      returns the entry as a null-terminated c-string
    */
    virtual const char*get_entry()const{return entry.c_str();}
    //! The pattern
    /*!
      returns the pattern of this object as null-terminated c-string
    */
    virtual const char*get_pattern()const{return pattern.c_str();}
    //! setting the entry
    /*!
      emptys the current entry and set it to What.
      \param What new entry
    */
    virtual void set_entry(const char*What){entry=What?What:"";}
    virtual void set_pattern(const char*What){pattern = What?What:"";}
    virtual void set_pattern(const std::string&What){pattern = What;}
    virtual void set_entry(const std::string&What){pattern = What;}
    virtual void setIsPassword(bool how){password_entry = how;}
    virtual void setIsNumeric(bool how){numeric_entry = how;}
    virtual void setLargeText(bool how){large_text = how;}
    virtual const bool isPassword()const{return password_entry;}
    virtual const bool isNumeric()const{return numeric_entry;}
    virtual const bool isLargeText()const{return large_text;}
    virtual const bool isEntry(const std::string&what)const{return what == entry;}

    const int operator <(const CPatternPair&old)const;
    const int operator ==(const CPatternPair&old)const;
};

inline const int CPatternPair::operator <(const CPatternPair&old)const
{
    return pattern<old.pattern;
}

inline const int CPatternPair::operator ==(const CPatternPair&old)const
{
    return pattern==old.pattern;
}

typedef std::vector<CPatternPair> PatternList;
typedef std::vector<CPatternPair>::iterator PatternIterator;

#endif

