// -*- Mode: C++; -*-
#ifndef __NULL_POINTER_EXCEPTION_H
#define __NULL_POINTER_EXCEPTION_H

#include <exception>
// required for the True64 C++ Compiler
#ifndef _RWSTD_THROW_SPEC_NULL
//! compatibility define
#define _RWSTD_THROW_SPEC_NULL throw()
#endif

#include <string>

/*!
 * \file nullpointer_exception.h
 * \brief implements an exception for accessing a null pointer
 * \author Rajko Albrecht
 */

//! Class for generating an exception for null pointer access
class nullpointer_exception : public std::exception {
private:
    std::string _what;
protected:
    //! not used constructor
    nullpointer_exception(){;}
public:
    //! standart constructor
    /*!
     * \param what_arg exception text
     */
    nullpointer_exception(const std::string&what_arg):_what(what_arg){;}
    //! whats the reason for the exception
    /*!
     * \return a string holding the error msg
     */
    virtual const char * what () const
	_RWSTD_THROW_SPEC_NULL
    {
        return _what.c_str();
    }
    //! empty standard destructor
    virtual ~nullpointer_exception()_RWSTD_THROW_SPEC_NULL{};
};

#endif
