// -*- Mode: C++; -*-
// $Id: change_type.h,v 2.9 2003/02/09 17:54:35 ral Exp $

#include "pairs.h"
#include "helpers/liste.h"
#include "helpers/stringlist.h"
#include "helpers/specials.h"

#ifndef change_type_included
#define change_type_included

//! helper class for alter tables
struct change_type : public string_pair{
    //! type of change
    enum c_type{
        //! do nothing
        none,
        //! new column
        add,
        //! change column
        mod,
        //! delete column
        del};
    //!
    string_pair columns;
    //! type of change
    c_type typ;

    //! simple contructor
    change_type():columns(){typ = none;}
};

typedef std::vector<change_type> base_change_list;
typedef base_change_list change_list;

inline change_list::const_iterator find_second(const change_list&where,const change_type&what)
{
    change_list::const_iterator a = where.begin();
    for (;a!=where.end();++a) {
        if (strcasecmp(a->columns.second.c_str(),what.columns.second.c_str())==0) {
            return a;
        }
    }
    return a;
}

inline change_list::iterator find_second(change_list&where,const change_type&what)
{
    change_list::iterator a = where.begin();
    for (;a!=where.end();++a) {
        if (strcasecmp(a->columns.second.c_str(),what.columns.second.c_str())==0) {
            return a;
        }
    }
    return a;
}

inline change_list::iterator find_second(change_list&where,const std::string&what)
{
    change_list::iterator _search_pos = where.begin();
    for (;_search_pos<where.end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.second.c_str(),what.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return _search_pos;
}

#if 0
change_list::iterator
find_second(const change_type&what,const iterator start_pos)
{
    _search_pos = start_pos;
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.second.c_str(),what.columns.second.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return end();
}

inline change_list::iterator
change_list::find(const change_type&what,iterator start_pos)
{
    _search_pos = start_pos;
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.first.c_str(),what.columns.first.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return end();
}

inline change_list::iterator
change_list::find_second(const std::string&what,iterator start_pos)
{
    _search_pos = start_pos;
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.second.c_str(),what.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return end();
}

inline change_list::iterator
change_list::find(const std::string&what,iterator start_pos)
{
    _search_pos = start_pos;
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.first.c_str(),what.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return end();
}

inline change_list::iterator
change_list::find_second(const char*what,iterator start_pos)
{
    std::string t =what?what:"";
    return find_second(t);
}

inline change_list::iterator
change_list::find(const char*what,iterator start_pos)
{
    std::string t =what?what:"";
    return find(t);
}
#endif

#endif
