// -*- Mode: C++; -*-
// getargv.h
// see cmdline.cpp for description


#include <string>
#include <map>
#include <vector>
#include <utility>

#ifndef __cmdline_h
#define __cmdline_h

class getOptions
{
public:
    getOptions(int how_many, char*argv[], char*singlepara, char*doublepara);
    getOptions();
    void StartParsing();
    void Reset();
    const std::string get_value(const char which)const;
    bool contains(const char which)const;
    void newOptions(int how_many, char*argv[], char*singlepara, char*doublepara);
    bool contains_unknown()const{return (wrong_argument||unknown.size()>0);}

protected:
    char getopt (int how_many, char*argv[], char*singlepara, char*doublepara, char*buffer,int*wo);
    int count;
    int more_than_one; // if a flag like "-abc" is given
    char * _singlepara;
    char * _doublepara;
    int _how_many;
    char**_args;
    bool wrong_argument;
    std::map<char,std::string> parameters;
    std::vector<std::string> names;
    std::vector<char> unknown;
};

#endif
