//-*-Mode: C++;-*-
/***************************************************************************
                          sendmessage.h  -  description                              
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// $Id: sendmessage.h,v 2.4 2000/03/19 14:51:26 ral Exp $

#include <string>

#ifndef SENDMESSAGE_H
#define SENDMESSAGE_H


/**
   A pure virtual class for message callbacks
   @author Rajko Albrecht
*/
class CSendMessage {
public:
    //! empty constructor
    CSendMessage();
    //! empty destructor
    virtual ~CSendMessage();
    //! send a message
    /*!
     * \param message a const char pointer containing the message text
     */
    virtual void append_message(const char*message)=0;
    //! send a message
    /*!
     * \param message a stl-string containing the message text
     */
    virtual void append_message(const std::string&message)=0;
};

#endif

