-- drop old stuff
DROP TABLE word;
DROP TABLE dictionary;
DROP TABLE analyzed;

-- move large object pointers
ALTER TABLE partdata RENAME COLUMN file TO file_old;
ALTER TABLE author RENAME COLUMN memo TO memo_old;
ALTER TABLE part RENAME COLUMN memo TO memo_old;
ALTER TABLE note RENAME COLUMN memo TO memo_old;
ALTER TABLE publication RENAME COLUMN memo TO memo_old;

-- create new text fields
ALTER TABLE partdata RENAME COLUMN file_new TO file;
ALTER TABLE author RENAME COLUMN memo_new TO memo;
ALTER TABLE part RENAME COLUMN memo_new TO memo;
ALTER TABLE note RENAME COLUMN memo_new TO memo;
ALTER TABLE publication RENAME COLUMN memo_new TO memo;

-- add keys
ALTER TABLE partdata ADD COLUMN no SERIAL;
ALTER TABLE author ADD COLUMN no SERIAL;
ALTER TABLE part ADD COLUMN no SERIAL;
ALTER TABLE note ADD COLUMN no SERIAL;
ALTER TABLE publication ADD no SERIAL;
ALTER TABLE publisher ADD no SERIAL;

-- create new relations
ALTER TABLE part ADD COLUMN publication_no int4;
ALTER TABLE part ALTER COLUMN publication_no SET DEFAULT 0;
ALTER TABLE partdata ADD COLUMN part_no int4;
ALTER TABLE partdata ALTER COLUMN part_no SET DEFAULT 0;
ALTER TABLE publication ADD COLUMN publisher_no int4;
ALTER TABLE publication ALTER COLUMN publisher_no SET DEFAULT 0;
ALTER TABLE publication ADD COLUMN orgpublisher_no int4;
ALTER TABLE publication ALTER COLUMN orgpublisher_no SET DEFAULT 0;
ALTER TABLE part ADD COLUMN intro_no int4;
ALTER TABLE part ALTER COLUMN intro_no SET DEFAULT 0;
ALTER TABLE note ADD COLUMN publication_no int4;
ALTER TABLE note ALTER COLUMN publication_no SET DEFAULT 0;
ALTER TABLE publication_author ADD COLUMN publication_no int4;
ALTER TABLE publication_author ALTER COLUMN publication_no SET DEFAULT 0;
ALTER TABLE publication_author ADD COLUMN author_no int4;
ALTER TABLE publication_author ALTER COLUMN author_no SET DEFAULT 0;
ALTER TABLE part_author ADD COLUMN part_no int4;
ALTER TABLE part_author ALTER COLUMN part_no SET DEFAULT 0;
ALTER TABLE part_author ADD COLUMN author_no int4;
ALTER TABLE part_author ALTER COLUMN author_no SET DEFAULT 0;
ALTER TABLE link ADD COLUMN obj_1 int4;
ALTER TABLE link ALTER COLUMN obj_1 SET DEFAULT 0;
ALTER TABLE link ADD COLUMN obj_2 int4;
ALTER TABLE link ALTER COLUMN obj_2 SET DEFAULT 0;

-- assign new relations
UPDATE part set publication_no=publication.no where part.publicationno=publication.oid;
UPDATE part set intro_no=partdata.no where part.intro=partdata.oid;
UPDATE partdata set part_no=part.no where partdata.partno=part.oid;
UPDATE publication set publisher_no=publisher.no where publication.publisherno=publisher.oid;
UPDATE publication set orgpublisher_no=publisher.no where publication.orgpublisherno=publisher.oid;
UPDATE note set publication_no=publication.no where note.publicationno=publication.oid;
UPDATE publication_author set publication_no=publication.no where publication_author.publicationno=publication.oid;
UPDATE publication_author set author_no=author.no where publication_author.authorno=author.oid;
UPDATE part_author set part_no=part.no where part_author.partno=part.oid;
UPDATE part_author set author_no=author.no where part_author.authorno=author.oid;
UPDATE note set obj_1=author.no where note.obj1=author.oid;
UPDATE note set obj_2=author.no where note.obj2=author.oid;
UPDATE note set obj_1=part.no where note.obj1=part.oid;
UPDATE note set obj_2=part.no where note.obj2=part.oid;
UPDATE note set obj_1=publication.no where note.obj1=publication.oid;
UPDATE note set obj_2=publication.no where note.obj2=publication.oid;
UPDATE note set obj_1=partdata.no where note.obj1=partdata.oid;
UPDATE note set obj_2=partdata.no where note.obj2=partdata.oid;
UPDATE note set obj_1=note.no where note.obj1=note.oid;
UPDATE note set obj_2=note.no where note.obj2=note.oid;

-- move old tables
ALTER TABLE partdata RENAME TO partdata_old;
ALTER TABLE author RENAME TO author_old;
ALTER TABLE part RENAME TO part_old;
ALTER TABLE note RENAME TO note_old;
ALTER TABLE publication RENAME TO publication_old;
ALTER TABLE publisher RENAME TO publisher_old;
ALTER TABLE link RENAME TO link_old;
ALTER TABLE part_author RENAME TO part_author_old;
ALTER TABLE publication_author RENAME TO publication_author_old;


-- drop old indices
DROP INDEX author_oid_index;
DROP INDEX part_publicationno_index;
DROP INDEX part_oid_index;
DROP INDEX partdata_oid_index;
DROP INDEX partdata_partno_index;
DROP INDEX publication_oid_index;
DROP INDEX publication_author_authorno_index;
DROP INDEX publication_author_bookno_index;
DROP INDEX part_author_authorno_index;
DROP INDEX part_author_partno_index;
DROP INDEX note_oid_index;
DROP INDEX note_publicationno_index;


CREATE TABLE author AS SELECT no, lastname, firstname, pseudonym, born, died, country, memo, created, modified FROM author_old;
CREATE INDEX author_no_i ON author (no);
-- DROP TABLE author_old;

CREATE TABLE part AS SELECT no, part_no, title, pages, memo, key, language, bibtex, intro_no, createbibtex, created, modified FROM part_old;
CREATE INDEX part_publication_no_i ON part (publication_no);
CREATE INDEX part_no_i ON part (no);
-- DROP TABLE part_old;

CREATE TABLE partdata AS SELECT no, part_no, file, astext, filename, type, created, modified FROM partdata_old;
CREATE INDEX partdata_no_i ON partdata (no);
CREATE INDEX partdata_part_no_i ON partdata (part_no);
-- DROP TABLE partdata_old;

CREATE TABLE publisher AS SELECT no, name, city, serie, created, modified FROM publisher_old;
-- DROP TABLE publisher;

CREATE TABLE publication AS SELECT no, title, subtitle, edition, editor, howpublished, organization, publisher_no, year, pages, translator, volume, number, month, series, type, key, orgtitle,orgpublisher_no, orgyear, isbn_issn, hidingplace, bibtex, entrytype, memo, createbibtex, created, modified FROM publication_old;
CREATE INDEX publication_no_i ON publication (no);
-- DROP TABLE publication_old;

CREATE TABLE publication_author AS SELECT publication_no, author_no, created, modified FROM publication_author_old;
CREATE INDEX publication_author_author_no_i ON publication_author (author_no);
CREATE INDEX publication_author_book_no_i ON publication_author (publication_no);
-- DROP TABLE publication_author;

CREATE TABLE part_author AS SELECT part_no, author_no, created, modified FROM part_author_old;
CREATE INDEX part_author_author_no_i ON part_author (author_no);
CREATE INDEX part_author_part_no_i ON part_author (part_no);
-- DROP TABLE part_author_old;

CREATE TABLE note AS SELECT no, title, memo, type, publication_no, created, modified FROM note_old;
CREATE INDEX note_no_i ON note (no);
CREATE INDEX note_publication_no_i ON note (publication_no);
-- DROP TABLE note_old;

CREATE TABLE link AS SELECT obj_1, obj_2, tbl, created, modified FROM link_old;
-- DROP TABLE link_old;
