/***************************************************************************
                          publbase.cpp  -  description
                             -------------------
    begin                : Fri Sep 24 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "publbase.h"
#include <assert.h>
#include <stdlib.h>
#define Inherited Table

// Creates new Publ
PublBase::PublBase(Sql *conn):Inherited("publication", conn) {
	initNew();
}

PublBase::PublBase(const char *dbname):Inherited("publication", dbname) {
	initNew();
}

void PublBase::initNew() {
  PublRec *publ=new PublRec;
  assert(publ);
  publ->empty();
  publ->id.set(newPubl());
  init(publ);
  _where="where publication.no=";
  _where+=publ->id.get();
}

PublBase::PublBase(const char *where, const char *dbname):Inherited("publication", dbname) {
	initWhere(where);
}

PublBase::PublBase(const char *where, Sql *conn):Inherited("publication", conn) {
	initWhere(where);
}

void PublBase::initWhere(const char *where) {
  PublRec *publ=Inherited::getPubl(where);
  if(!publ) {
    publ=new PublRec;
    assert(publ);
    publ->empty();
    publ->id.set((Oid)InvalidOid);
  }
  init(publ);
	if(where)	_where=where;
	else _where="";
}

PublBase::~PublBase() throw() {
}

KaspaRec *PublBase::invalid() {
		KaspaRec *publ=new PublRec;
		publ->id.set((Oid)InvalidOid);
		return publ;
}


KaspaRec *PublBase::read(const char *where) {
	return getPubl(where);
}	

void PublBase::write(const char *where, bool block) {
    updatePubl(publ(), where, block);
}

void PublBase::del(Oid o) {
    deletePubl(o);
    publ()->empty();
    publ()->id.set((Oid)InvalidOid);
}

PublRec *PublBase::publ() {
	if(!dynamic_cast<PublRec*>(rec))
		abort();
	return dynamic_cast<PublRec*>(rec);
}


Oid PublBase::createAuthor() {
	Oid o=newAuthor();
	newPublAuthor(publ()->id.get(), o);
	return o;
}

void PublBase::insertAuthor(Oid o) {
	newPublAuthor(publ()->id.get(), o);
}
	
void PublBase::removeAuthor(Oid o) {
	deletePublAuthor(publ()->id.get(), o);
}

Oid PublBase::createPart() {
	return newPart(publ()->id.get());
}

void PublBase::deletePart(const char *where) {
	Inherited::deletePart(where);
}

Oid PublBase::createNote() {
	Oid o=newNote(publ()->id.get());
	insertLink(o);
	return o;
}

Oid PublBase::createPublisher() {
	Oid o=newPublisher();
	return o;
};

Oid PublBase::createJournal() {
	Oid o=newPublisher();
	return o;
};

NoteTitle *PublBase::getNotes() {
	Str s=Str("where publication_no=");
	oid2str(publ()->id.get(), &s);
	s+=" order by title";
	return getNoteTitles(s);
}


/**  */
int PublBase::bibTexIndex(Oid author, Oid publ){
	return KaspaBase::bibTexIndex(author, getYear(), publ);
}







