/***************************************************************************
                          note.cpp  -  description
                             -------------------
    begin                : Tue Sep 7 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "note.h"
#include "kaspawidget.h"
#include "resource.h"
#include <kapp.h>
#include <qstring.h>
#include "selectiondlg.h"
#include "notetreedlg.h"
#include <qpopupmenu.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qwhatsthis.h>
#include <kmdcodec.h>

#define Inherited NoteData

CommandSetup notecs[] = {	{ID_NOTE_INSNOTE,		RW+RO},
													{ID_NOTE_INSAUTHOR,	RW+RO},
													{ID_NOTE_INSPART, 	RW+RO},
													{ID_NOTE_INSPUBL,		RW+RO},
													{ID_NOTE_REMLINK,		RW+RO},
													{ID_NOTE_DELREC,		RW},
													{ID_NOTE_FLUSH,			RW},
													{ID_NOTE_RESET,			RW+RO+INV} };


// NoteBase-Constructor reads row matching WHERE-Clause.
Note::Note(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name)
{
	linklist=new LinkListBox(panner);
	memo=new MyTextEdit(panner);

	setTabOrder(title, linklist);
	setTabOrder(linklist, memo);

	QWhatsThis::add(title,    	i18n("The title of the note."));
	QWhatsThis::add(memo , 			i18n("Here is some place to describe the subject of the note."));
	QWhatsThis::add(linklist,		i18n("This box shows the links of the notes. There are two types of notes:\n" \
																	 "The toplevel notes are created from the 'New Note' entry in the menu." \
																	 "This type of notes connects only to other notes.\n"
																	 "The second type is created from the 'Create Note' buttons of the toolsbars " \
																	 "which are part of the publication, author or part views. These notes connect " \
																	 "only to other notes of the same publication (parts and files included) or to " \
																	 "toplevel notes. It is not possible to connect notes which have relations to " \
																	 "different publications.\n" \
																	 "This may seem stange but it helps to form categories.\n" \
																	 "You may open the link by double-clicking the item in the same window " \
																	 "or via the context menu in an new window. You can open the context menu " \
																	 "by clicking the right mouse button. You may insert and delete " \
																	 "notes with the buttons of the toolbar."));
	
	
	debug("Note::Note(QString, QWidget, char*)");
	if(url.command()=="new")
	  note = new NoteBase(conn);
	else
	  note = new NoteBase(url.where(), conn);
  ASSERT(note);
	note->setCallBack(&idle);
	QString s("kaspa://note#where note.no="); s+=QString().setNum(note->id());
	_url=s;
  connect(linklist,   SIGNAL(open(Oid, const char*, bool)), this, SLOT(showLink(Oid,const char*, bool)));
	linklist->setTitle("Links");
  setupEditorConnections();
}

Note::~Note()
{
	debug("Note::~Note()");
	delete note;
}

bool Note::isValid() {
	try {
	  return note->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}

void Note::reread() {
	try {
		setWorkingGUI();
  	note->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
	  setFields();
}

void Note::setFields() {
  if(isValid()) {
		try {
			setWorkingGUI();
			if(note->getType()==0) {
				emit disableCommand(ID_NOTE_INSPUBL);
				emit disableCommand(ID_NOTE_INSPART);
			} else {
				emit enableCommand(ID_NOTE_INSPART);
				emit enableCommand(ID_NOTE_INSPUBL);
			}
		  title->setText(note->getTitle());
	  	memo->setText(QCString(note->getMemo()));
			created->setText(QString("created: ")+note->getCreated());
			modified->setText(QString("modified: ")+note->getModified());
		  linklist->set(note->getLinks());
		} catch(KaspaErr& err) {
			handleWarning(err);
		}
	}
	setupGUI();
}

void Note::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void Note::save(bool block) {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
    	if(strcmp(title->text(), note->getTitle()))
	       note->setTitle(title->text());
  	  if(strcmp(QCString(memo->text()), note->getMemo()))
    	   note->setMemo(QCString(memo->text()));
	    note->flush(block);
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Note::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
  linklist->setEnabled(false);
	memo->setEnabled(false);
	for(unsigned int i=0; i<sizeof(notecs)/sizeof(CommandSetup); i++)
		emit enableCommand(notecs[i].command, ((notecs[i].setup&INV)==INV));
}	

void Note::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
 	unlockGUI();
	for(unsigned int i=0; i<sizeof(notecs)/sizeof(CommandSetup); i++)
		emit enableCommand(notecs[i].command, ((notecs[i].setup&RW)==RW));
  linklist->setEnabled(true);
	memo->setEnabled(true);
}

void Note::setWorkingGUI() {
	if(isReadOnly() || !isValid()) {
		lockGUI();
		memo->setEnabled(false);
	}
	else {
		unlockGUI();
		memo->setEnabled(true);
	}
	Inherited::setWorkingGUI();
  linklist->setEnabled(false);
	for(unsigned int i=0; i<sizeof(notecs)/sizeof(CommandSetup); i++)
		emit enableCommand(notecs[i].command, ((notecs[i].setup&WORK)==WORK));
}

void Note::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	title->setEnabled(false);
	memo->setEnabled(false);
  linklist->setEnabled(true);
	for(unsigned int i=0; i<sizeof(notecs)/sizeof(CommandSetup); i++)
		emit enableCommand(notecs[i].command, ((notecs[i].setup&RO)==RO));
}


void Note::del() {
	try {
	  if(isValid() && !isReadOnly() && !isWorking() && deleteDlg()) {
			setWorkingGUI();
	  	note->deleteRec();
		  setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool Note::closeRequest() {
//	setWorkingGUI();
 	save(true);
	setupGUI();
  return true;
}
	
void Note::remLink() {
	try {
		Oid o=linklist->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		note->removeLink(o);
		save();
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Note::showLink(Oid i, const char *s, bool w) {
	if(i==InvalidOid) return;
	QString t("kaspa://"); t+=s; t+="#where "; t+=s; t+=".no="; t+=QString().setNum(i);
	requestURL(t, w);
}

void Note::insNote() {
	try {
		QString s("");
		if(note->getPublNo()!=InvalidOid) {
			s="where publication_no=0 or publication_no=";
			s+=QString().setNum(note->getPublNo());
	  }
		s+=" order by title";
		NoteTitle *notes=note->getNoteTitles(s);
		PublTitle *publs=note->getPubls();
		NoteTreeDlg dlg(notes, publs);
		if(dlg.exec()) {
			if(dlg.getOid()==InvalidOid) return;
			setWorkingGUI();
			note->insertLink(dlg.getOid());
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Note::insAuthor() {
	try {
		SelectionDlg dlg(note->getAuthors(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			note->insertLink(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		

/*
void Note::insPubl() {
	try {
		SelectionDlg dlg(note->getPubls(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			note->insertLink(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		


void Note::insPart() {
	try {
		SelectionDlg dlg(note->getParts(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			note->insertLink(o);
			save();
			setFields();			
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
*/

KToolBar *Note::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
	toolbar->insertButton(BarIcon("insauthor.xpm"), ID_NOTE_INSAUTHOR, SIGNAL(clicked()),
				this, SLOT(insAuthor()), true, i18n("Insert Author") );
	toolbar->insertButton(BarIcon("insnote.xpm"), ID_NOTE_INSNOTE, SIGNAL(clicked()),
				this, SLOT(insNote()), true, i18n("Insert Note") );
/*	toolbar->insertButton(BarIcon("inspubl.xpm"), ID_NOTE_INSPUBL, SIGNAL(clicked()),
				this, SLOT(insPubl()), true, i18n("Insert Publication") );
	toolbar->insertButton(BarIcon("inspart.xpm"), ID_NOTE_INSPART, SIGNAL(clicked()),
				this, SLOT(insPart()), true, i18n("Insert Part") ); */

	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("dellink.xpm"), ID_NOTE_REMLINK, SIGNAL(clicked()),
				this, SLOT(remLink()), true, i18n("Remove Link") );

	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("filedel.xpm"), ID_NOTE_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );

	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("filefloppy.xpm"), ID_NOTE_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
	toolbar->insertButton(BarIcon("reload.xpm"), ID_NOTE_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->insertLineSeparator();

  setupToolbar(toolbar);

	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
	return toolbar;
}


