/***************************************************************************
                          str.h  -  description                              
                             -------------------                                         
    begin                : Mon Sep 4 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef STR_H
#define STR_H

#include "kaspaerr.h"


char *mystrdup(const char *s);
char *uint2str(unsigned int i);
char *int2str(unsigned int i);

class StrErr: public KaspaErr {
 public:
  StrErr(const char *s=0);
};

/**
  *@author Jan Mueller
  */

class Str {
	char *s;
	bool resize(int len);
public: 
	Str();
	Str(Str& str);
	Str(const char *str);
	~Str();

	Str&  operator+= ( const char *str );
	Str&  operator+= ( char c );
	Str&  operator+= ( int i );
	Str&  operator+= ( unsigned int i );
	Str&  operator= ( const Str &s );
	Str&  operator= ( const char *str );
	char& operator[] (int i);
	const char& operator[] (int i) const;
	operator const char *() const;
	void copy(char *s) const;
	const char *data() const;
	int length() const;
};


inline Str operator+( const Str &s1, const Str &s2 ) {
	Str tmp( s1.data() );
	tmp += s2;
	return tmp;
}

inline Str operator+( const Str &s1, const char *s2 ) {
	Str tmp( s1.data() );
	tmp += s2;
	return tmp;
}

inline Str operator+( const char *s1, const Str &s2 ) {
	Str tmp( s1 );
	tmp += s2;
	return tmp;
}

inline Str operator+( const Str &s1, char c2 ) {
	Str tmp( s1.data() );
	tmp += c2;
	return tmp;
}

inline Str operator+( char c1, const Str &s2 ) {
	Str tmp;
	tmp += c1;
	tmp += s2;
	return tmp;
}

inline Str operator+( const Str &s1, int i ) {
	Str tmp( s1.data() );
	tmp += i;
	return tmp;
}

inline Str operator+( int i, const Str &s2 ) {
	Str tmp;
	tmp += i;
	tmp += s2;
	return tmp;
}

inline Str operator+( const Str &s1, unsigned int i ) {
	Str tmp( s1.data() );
	tmp += i;
	return tmp;
}

inline Str operator+( unsigned int i, const Str &s2 ) {
	Str tmp;
	tmp += i;
	tmp += s2;
	return tmp;
}



#endif





