/***************************************************************************
                          authorselect.h  -  description                              
                             -------------------                                         
    begin                : Sat Oct 16 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef AUTHORSELECT_H
#define AUTHORSELECT_H

#include <selection.h>
#include <kaspaurl.h>
/**
  *@author Jan Mueller
  */

class AuthorSelect : public Selection  {
   Q_OBJECT

private:
		AuthorSelect &operator=(const AuthorSelect&);
		AuthorSelect(const AuthorSelect&);

		KaspaBase *kaspa;
		KaspaURL _url;
public:
	AuthorSelect(KaspaURL url, Sql *conn, const char *caption=0L, QWidget *parent=0, const char *name=0);
	~AuthorSelect();
	bool isWorking();
	Title *getList();
	const char *url() { return _url; }
	void open(Oid o, bool w) { requestAuthor(o,w); }
};

#endif























