/***************************************************************************
                           picturewidgetimpl.cpp
                           -------------------
    begin                : Sun Sep 6 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <kdebug.h>
#include <klocale.h>
#include "picturewidgetimpl.h"
#include <qslider.h>
#include <qcheckbox.h>
#include "cfgdata.h"
#include "kdetv.h"
#include "sourcemanager.h"

PictureWidgetImpl::PictureWidgetImpl(QWidget* parent, Kdetv* ktv, ConfigData* cfg)
    : PictureWidget(parent),
      SettingsDialogPage(i18n("Picture"),
                         i18n("Configure Picture Options"),
                         "colorize"),
      _ktv(ktv),
      _srcm(ktv->sourceManager()),
      _cfg(cfg)
{
}

PictureWidgetImpl::~PictureWidgetImpl()
{
}

void PictureWidgetImpl::setup()
{
    connect(_hue, SIGNAL(valueChanged(int)),
            this, SLOT(slotHueChanged(int)));
    connect(_colour, SIGNAL(valueChanged(int)),
            this, SLOT(slotColourChanged(int)));
    connect(_brightness, SIGNAL(valueChanged(int)),
            this, SLOT(slotBrightnessChanged(int)));
    connect(_whiteness, SIGNAL(valueChanged(int)),
            this, SLOT(slotWhitenessChanged(int)));
    connect(_contrast, SIGNAL(valueChanged(int)),
            this, SLOT(slotContrastChanged(int)));

    _oldHue = _srcm->hue();
    _hue->setValue(_srcm->hue());

    _oldColour = _srcm->colour();
    _colour->setValue(_srcm->colour());

    _oldBrightness = _srcm->brightness();
    _brightness->setValue(_srcm->brightness());

    _oldWhiteness = _srcm->whiteness();
    _whiteness->setValue(_srcm->whiteness());

    _oldContrast = _srcm->contrast();
    _contrast->setValue(_srcm->contrast());

    // _autoScale->setChecked(_cfg->autoScaleEnabled);
}

void PictureWidgetImpl::defaults()
{
    const ConfigData& def = ConfigData::getDefaultConfig();

    slotHueChanged(def.hue);
    slotColourChanged(def.colour);
    slotBrightnessChanged(def.brightness);
    slotWhitenessChanged(def.whiteness);
    slotContrastChanged(def.contrast);

    // _autoScale->setChecked(true);

    setup();
}

void PictureWidgetImpl::apply()
{
    _cfg->hue              = _hue->value();
    _cfg->colour           = _colour->value();
    _cfg->brightness       = _brightness->value();
    _cfg->whiteness        = _whiteness->value();
    _cfg->contrast         = _contrast->value();
    // _cfg->autoScaleEnabled = _autoScale->isChecked();
    _ktv->savePictureSettings();
}

void PictureWidgetImpl::cancel()
{
    slotHueChanged(_oldHue);
    slotColourChanged(_oldColour);
    slotBrightnessChanged(_oldBrightness);
    slotWhitenessChanged(_oldWhiteness);
    slotContrastChanged(_oldContrast);
}

/***************************************************************************
 *
 * Private Slots
 *
 ***************************************************************************/

void PictureWidgetImpl::slotHueChanged(int hue)
{
    _srcm->setHue(hue);
} // slotHueChanged

void PictureWidgetImpl::slotColourChanged(int colour)
{
    _srcm->setColour(colour);
} // slotColourChanged

void PictureWidgetImpl::slotBrightnessChanged(int brightness)
{
    _srcm->setBrightness(brightness);
} // slotBrightnessChanged

void PictureWidgetImpl::slotWhitenessChanged(int whiteness)
{
    _srcm->setWhiteness(whiteness);
} // slotWhitenessChanged

void PictureWidgetImpl::slotContrastChanged(int contrast)
{
    _srcm->setContrast(contrast);
} // slotContrastChanged

#include "picturewidgetimpl.moc"
