// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#ifndef __KDETVSIMON_PLUGIN_H
#define __KDETVSIMON_PLUGIN_H

#include <kdetvmiscplugin.h>

class Kdetv;
class QCheckBox;
class VbiManager;

/**
 * Simon OSD Plugin
 */
class KdetvSimon : public KdetvMiscPlugin
{
    Q_OBJECT


public:
    KdetvSimon(Kdetv *ktv, QWidget *parent = 0, const char* name = 0);
    virtual ~KdetvSimon();

    QWidget *configWidget(QWidget *parent, const char *name);
    void     saveConfig();

protected slots:
    void channelChanged();
    void captionData(int pgno);
    void programTitle(const QString& title);


private:
    bool _cfg_displayText;
    bool _cfg_displayTitle;

    QCheckBox* _cb_dispText;
    QCheckBox* _cb_dispTitle;

    VbiManager* _vbimgr;
};

#endif

