%define version 0.3p
%define release 1
%define serial  1
%define prefix  /opt/kde3

Name:      synk
Summary:   Directory Synchronisation/Mirroring Tool
Version:   %{version}
Release:   %{release}
Serial:    %{serial}
Source:    http://devel-home.kde.org/~pfeiffer/synk/synk-%{version}.tgz
URL:       http://devel-home.kde.org/~pfeiffer/synk/
Copyright: GPL
Packager:  Carsten Pfeiffer <pfeiffer@kde.org>
Group:     X11/KDE/Utilities
BuildRoot: /tmp/synk-%{version}-root
Prefix:    %{prefix}

%description
Synk is a directory synchroniser - what might be more commonly known in the unix world as a mirroring tool.

It's reason for existance is to create "connections" between directories, so that they can easily be kept in sync with each other.  Synk will copy all the files from one directory to the other, and then when run at a later date it will copy only the new or changed files in order to synchronise the files in the two directories.
 
Install with '--prefix $KDEDIR' unless you have KDE in /opt/kde3

%prep
rm -rf $RPM_BUILD_ROOT

%setup -n synk-%{version}

%build
export KDEDIR=%{prefix}
CXXFLAGS="$RPM_OPT_FLAGS -fno-exceptions -pipe" LDFLAGS=-s ./configure --prefix=%{prefix} --enable-final --disable-debug
mkdir -p $RPM_BUILD_ROOT
make

%install
make install DESTDIR=$RPM_BUILD_ROOT

cd $RPM_BUILD_ROOT
 
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.%{name}
 
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.%{name}
 
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.%{name}

%clean
rm -rf $RPM_BUILD_ROOT
rm -f $RPM_BUILD_DIR/file.list.%{name}

%files -f ../file.list.%{name}

