/***************************************************************************
                          kbundoaction.h  -  description
                             -------------------
    begin                : Tue Sep 10 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: kbundoaction.h,v 1.1 2002/09/13 18:43:08 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBUNDOACTION_H
#define KBUNDOACTION_H

#include <qstring.h>
#include <qptrlist.h>

class KBudgetDoc;
class Account;
class Transaction;
class QDate;

/*
  TODO:
   Main Window:
    Edit account
    Rename account
    Delete account
    Nww Transaction
   Transaction Window:
     all
*/

/**An undo/redo action
  *@author Richard Garand
  */

class KBUndoAction {
  public: 
    KBUndoAction(KBudgetDoc* doc);
    virtual ~KBUndoAction();

    virtual void undo() = 0;
    virtual void redo() = 0;
  protected:
    KBudgetDoc* m_doc;
};

class KBUndoGroup : public KBUndoAction {
  public:
    KBUndoGroup(KBudgetDoc* doc);
    ~KBUndoGroup();

    void undo();
    void redo();

    void add(KBUndoAction* act);
  private:
    QPtrList<KBUndoAction> list;
};

class KBAccountUndo : public KBUndoAction {
  public:
    enum actions { UA_NONE = 0, UA_ADD, UA_DEL, UA_RENAME, UA_STBALANCE };

    KBAccountUndo(KBudgetDoc* doc, actions action, int id);
    ~KBAccountUndo();

    void undo();
    void redo();
  private:
    void allocatePtr();
    void storeAccount();
    void recreateAccount();
  
    actions m_action;
    int m_id;

    Account* savedAcct;
    QString savedName;
    float savedValue;
};

class KBTransactionUndo : public KBUndoAction {
  public:
    enum actions { UT_NONE = 0, UT_ADD, UT_DEL, UT_DESCRIPTION, UT_MODIFIED };

    KBTransactionUndo(KBudgetDoc* doc, actions action, int id);
    ~KBTransactionUndo();

    void undo();
    void redo();
  private:
    void allocatePtr();
    void store();
    void recreate();

    actions m_action;
    int m_id;

    Transaction* saved;
    QString savedDesc;
    float savedValue;
    QDate savedDate;
};

#endif
