


#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvasspline_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasSplineImp::QCanvasSplineImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasSplineImp::~QCanvasSplineImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasSplineImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasSplineImp *meth = new QCanvasSplineImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasSplineImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_setControlPoints_3, "setControlPoints" },
        { Method_controlPoints_4, "controlPoints" },
        { Method_closed_5, "closed" },
        { Method_rtti_6, "rtti" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasSplineImp *meth = new QCanvasSplineImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasSpline pointer from an Object.
 */
QCanvasSpline *QCanvasSplineImp::toQCanvasSpline( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasSpline *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasSpline" )
        return 0;

    return op->toNative<QCanvasSpline>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasSplineImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasSpline_1:
             return QCanvasSpline_1( exec, args );
             break;

         default:
             break;
    }

    QString msg = i18n("QCanvasSplineCons has no constructor with id '%1'.").arg(id);
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Object QCanvasSplineImp::QCanvasSpline_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter QCanvas *
    return KJS::Object();

    QCanvas * arg0; // Dummy


    // We should now create an instance of the QCanvasSpline object

    QCanvasSpline *ret = new QCanvasSpline(

          arg0 );


}

KJS::Value QCanvasSplineImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasSplineImp::toQCanvasSpline( self );

    switch( id ) {

    case Method_setControlPoints_3:
        return setControlPoints_3( exec, self, args );
        break;

    case Method_controlPoints_4:
        return controlPoints_4( exec, self, args );
        break;

    case Method_closed_5:
        return closed_5( exec, self, args );
        break;

    case Method_rtti_6:
        return rtti_6( exec, self, args );
        break;

    default:
        break;
    }

    QString msg = i18n( "QCanvasSplineImp has no method with id '%1'." ).arg( id );
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Value QCanvasSplineImp::setControlPoints_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QPointArray
    return KJS::Value();

    QPointArray arg0; // Dummy

    bool arg1 = extractBool(exec, args, 1);

      instance->setControlPoints(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasSplineImp::controlPoints_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->controlPoints(  );
      return KJS::Value(); // Returns 'QPointArray'

}

KJS::Value QCanvasSplineImp::closed_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->closed(  );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasSplineImp::rtti_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


