// Qt includes
#include <qstring.h>
#include <qlistview.h>

// KDE includes
#include <klistview.h>

// kmtraceviewer includes
#include "KMtraceLeaksViewItem.hh"

KMtraceLeaksViewItem::KMtraceLeaksViewItem( QListViewItem *parent, QString str )
  : KListViewItem( parent, str )
{
}

KMtraceLeaksViewItem::KMtraceLeaksViewItem( QListView *parent, QString s1, QString &s2,
                                            QString &s3, QString &s4, QString s5)
  : KListViewItem( parent, s1, s2, s3, s4, s5 )
{
}			     

int KMtraceLeaksViewItem::compare( QListViewItem *item, int column, bool ascending ) const
{
   switch( column ) {
      // the callstack and address column should not be sortable!
      case 0:
      case 4:
         if( ascending ) {
            return KListViewItem::compare( item, column, TRUE );
         } else {
            return -KListViewItem::compare( item, column, TRUE );
         }
         break;

      // the others are number, not srings
      case 1:
      case 2:
      case 3:
         if( key( column, ascending ).toInt( ) == item->key( column, ascending ).toInt( ) ) {
            return 0;
         } else if( key( column, ascending ).toInt( ) < item->key( column, ascending ).toInt( ) ) {
            return -1;
         } else {
            return 1;
         }
         break;

      // unknown or new items are sorted in the default way
      default:
         return KListViewItem::compare( item, column, ascending );
   }
}

void KMtraceLeaksViewItem::setModel( QObject *obj )
{
   m_model = obj;
}

QObject *KMtraceLeaksViewItem::getModel( )
{
   return m_model;
}
   
