#ifndef __KMTRACE_SOURCECODEVIEW__H__
#define __KMTRACE_SOURCECODEVIEW__H__

// KDE includes
#include <keditcl.h>

/**
 * The viewer for source code. It shows a source code file and highlights
 * at a given line.
 *
 * @short The viewer for source code
 * @author Andreas Baumann <andreas_baumann@users.sourceforge.net>
 * @version $ProjectMajorVersion: 0 $
 */
class KMtraceSourceCodeView : public KEdit
{
   Q_OBJECT
   
   public:
      /**
       * Create a new source code viewer.
       *
       * @param parent the parent widget of the source code viewer
       */
      KMtraceSourceCodeView( QWidget *parent );

   public slots:
      /**
       * Tells the source code viewer to show a different module and
       * mark the line and set the visible area so that the line in the
       * source code can be seen. Normally connected to the signal
       * @ref KMtraceLeaksView::moduleChanged which gets called when the
       * user changes the focus in the list of modules. See also slot
       * @ref slotModuleUnselect.
       *
       * @param module the filename of file containig the source code
       *        of the leaking code
       * @param line set the focus to this line
       */
      void slotModuleChanged( QString module, int line );
      
      /**
       * Tells the source code viewer to show no source code (because none is
       * available either in a library call or when having the list view
       * focus not within the function call stack.
       */
      void slotModuleUnselect( );
};

#endif
