#ifndef __KMTRACE_STATISTICSVIEW__H__
#define __KMTRACE_STATISTICSVIEW__H__

// Qt includes
#include <qwidget.h>
#include <qlabel.h>

// KMtraceViewer includes
#include "KMtraceModel.hh"

class KMtraceStatisticsView : public QLabel
{
   Q_OBJECT
   
   public:
      // create a label with reference
      KMtraceStatisticsView( QWidget *parent, KMtraceModel *model );
      
      // set a new model (e.g. if a new ktreefile is loaded)
      void setModel( KMtraceModel *model );

   public slots:
      void slotModelChanged( );
      
   private:
      void updateView( );

   private:
      KMtraceModel *m_model;
};

#endif
