/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kfiledialog.h>

// command includes
#include "askforfilescommand.h"
#include "askforfileswidget.h"

using namespace WorKflow;

AskForFilesCommand::AskForFilesCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  AskForFilesWidget* w = new AskForFilesWidget(this);
  setWidget(w);
}

AskForFilesCommand::~AskForFilesCommand()
{
}

void AskForFilesCommand::execute()
{
  QString prompt = value("prompt").nextString();
  QString filter = value("filter").asStringList().join("\n");
  if (filter.isEmpty())
    filter = QString::null;
  QString folder = value("folder").nextString();
  if (filter.isEmpty())
    filter = QString::null;
  bool multiple = value("multiple").nextBoolean();

  QStringList res;
  if (multiple) {
    QStringList files = KFileDialog::getOpenFileNames(folder, filter, widget(), prompt);
    if (files.isEmpty()) {
      // cancel
      emit aborted();
      return;
    }
    res = files;
  } else {
    QString file = KFileDialog::getOpenFileName(folder, filter, widget(), prompt);
    if (file.isEmpty()) {
      // cancel
      emit aborted();
      return;
    }
    res << file;
  }

  setResult("files", Value::stringList("org.kde.public.file", res));
}

#include "askforfilescommand.moc"
