/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef GETFILESWIDGET_H
#define GETFILESWIDGET_H

// KDE includes
#include <kurl.h>

// command includes
#include "getfileswidgetbase.h"

class GetFilesWidget : public GetFilesWidgetBase
{
  Q_OBJECT

public:
  GetFilesWidget(WorKflow::Command* command);
  ~GetFilesWidget();

  QStringList urls();
  void setUrls(const KURL::List& urls);
  void addUrls(const KURL::List& urls);

protected slots:
  virtual void addFile();
  virtual void removeFile();
  virtual void moveUp();
  virtual void moveDown();
  virtual void updateButtons();
  virtual void handleDropEvent(QDropEvent*);

private:
  void addUrl(const KURL& url);
};

#endif

