/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "document.h"
#include "result.h"
#include "datatype.h"

// command includes
#include "loadfromvariablecommand.h"
#include "loadfromvariablewidget.h"
#include "changevariablecommand.h"
#include "modifyvariableservice.h"
#include "serviceinfo.h"

using namespace WorKflow;

LoadFromVariableCommand::LoadFromVariableCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  LoadFromVariableWidget* w = new LoadFromVariableWidget(this);
  setWidget(w);

  // trigger type check when command is modified
  connect(this, SIGNAL(modified(Command*)), this, SIGNAL(typeCheckNeeded()));
}

LoadFromVariableCommand::~LoadFromVariableCommand()
{
}

void LoadFromVariableCommand::execute()
{
  QString varname = value("variable").nextString();

  setResult("output", document()->variable(varname));
}

void LoadFromVariableCommand::typeCheck(Result* prev)
{
  Command::typeCheck(prev);

  QString varname = value("variable").nextString();

  ServiceInfo info(document());
  ServiceInfo::List vars = info.query(row(), "modify_variable");

  Datatype* outtype = 0;
  for (ServiceInfo::List::ConstIterator i = vars.begin(); i != vars.end(); ++i) {
    ModifyVariableService* var = static_cast<ModifyVariableService*>(*i);
    if (var->name() == varname)
      outtype = var->datatype();
  }

//   ChangeVariableCommand* var = 0;
//   Datatype* outtype = 0;
// 
//   // find last "Store in variable" command which stores in varname
//   for (int i = 0; i != row(); ++i) {
//     Command* cmd = document()->commandAt(i);
//     if (i != 0 && cmd->inherits("ChangeVariableCommand")) {
//       ChangeVariableCommand* varcmd = static_cast<ChangeVariableCommand*>(cmd);
//       if (varcmd->variableName() == varname) {
//         var = varcmd;
//         Command* before = document()->commandAt(i - 1);
//         if (before->output())
//           outtype = before->output()->type();
//       }
//     }
//   }

  if (!outtype) {
    result("output")->setProblem(Slot::MissingInput);
  } else {
    result("output")->setType(outtype->id());
  }
}

#include "loadfromvariablecommand.moc"
