/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "command.h"
#include "lineedit.h"

// command includes
#include "loadfromvariablewidget.h"
#include "selectvariabledialog.h"

using namespace WorKflow;

LoadFromVariableWidget::LoadFromVariableWidget(Command* command)
  : LoadFromVariableWidgetBase(0)
{
  setCommand(command);
}

LoadFromVariableWidget::~LoadFromVariableWidget()
{
}

void LoadFromVariableWidget::chooseVariable()
{
  QString name = SelectVariableDialog::select(this, command()->document(), command()->row());
  if (!name.isNull())
    m_variableEdit->setText(name);
}

#include "loadfromvariablewidget.moc"
