/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWAPPLICATIONDESCRIPTION_H
#define WORKFLOWAPPLICATIONDESCRIPTION_H

// Qt includes
#include <qvaluelist.h>

// WorKflow includes
#include "xmldescription.h"

// forward declarations
namespace WorKflow
{
  class Application;
  class ApplicationFactoryBase;
  class LibraryDescription;
}

namespace WorKflow
{
  /**
    @author Thomas Kadauke <tkadauke@gmx.de>
  */
  class ApplicationDescription : public WorKflow::XMLDescription
  {
  public:
    typedef QValueList<Application*> List;

    ApplicationDescription(LibraryDescription* parent);
    ~ApplicationDescription();

    void setFactory(ApplicationFactoryBase* factory);
    ApplicationFactoryBase* factory() const;

    void addInstance(Application* instance);
    void removeInstance(Application* instance);

    List instances();
    List runningInstances();

    QString executableName() const;
    QString dcopName() const;
    bool isUnique();

    void setExecutableName(const QString& name);
    void setDcopName(const QString& name);
    void setUnique(bool unique);

    virtual void readXML(const QDomElement& e);
    virtual void writeXML(QDomDocument& doc, QDomElement& e);

  private:
    LibraryDescription* m_parent;
    ApplicationFactoryBase* m_factory;
    List m_instances;
    QString m_exeName;
    QString m_dcopName;
    bool m_unique;
  };
}

#endif
