/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef COMMANDDRAG_H
#define COMMANDDRAG_H

// Qt includes
#include <qdragobject.h>
#include <qvaluelist.h>

// WorKflow includes
#include "commandinfo.h"

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class CommandDrag : public QDragObject
  {
    Q_OBJECT
  public:
    /**
     * @author Thomas Kadauke
     */
    class Info
    {
    public:
      enum Kind {
        NewCommand,
        ExistingCommand,
        CopiedCommands
      };

      inline Info() {}
      inline Info(const QString& commandId)
        : m_kind(NewCommand), m_commandId(commandId), m_row(0), m_column(0) {}
      inline Info(const QString& commandId, int row, int column)
        : m_kind(ExistingCommand), m_commandId(commandId), m_row(row), m_column(column) {}
      inline Info(const CommandInfoList& commands)
        : m_kind(CopiedCommands), m_row(0), m_column(0), m_commandInfos(commands) {}

//       inline void setCommandId(const QString& commandId) { m_commandId = commandId; }
//       inline void setRow(int row) { m_row = row; }
//       inline void setColumn(int column) { m_column = column; }

      inline Kind kind() const { return m_kind; }
      inline QString commandId() const { return m_commandId; }
      inline int row() const { return m_row; }
      inline int column() const { return m_column; }
      inline CommandInfoList copiedCommands() const { return m_commandInfos; }

    private:
      Kind m_kind;
      QString m_commandId;
      int m_row;
      int m_column;
      CommandInfoList m_commandInfos;
    };

    CommandDrag(const Info& info, QWidget* dragSource = 0, const char* name = 0);
    ~CommandDrag();

    virtual const char* format(int index) const;
    QByteArray encodedData(const char* format) const;

    static bool canDecode(const QMimeSource* source);
    static bool decode(const QMimeSource* source, Info& info);

  private:
    Info m_info;
  };
}

#endif
