/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>

// WorKflow includes
#include "result.h"
#include "parameter.h"
#include "result.h"
#include "command.h"
#include "commanddescription.h"
#include "commandmanager.h"
#include "resultdescription.h"

using namespace WorKflow;

Result::Result(Command* command, ResultDescription* desc)
  : Slot(command, desc)
{
  command->addResult(this);

  QString param = desc->parameter();
  if (!param.isEmpty()) {
    setTypeIds(command->parameter(param)->typeIds());
    m_linkedParameter = param;
  } else {
    setTypeIds(desc->typeIds());
  }
}

Result::~Result()
{

}

void Result::setValue(const Value& value)
{
  m_value = value;
}

Value Result::value()
{
  return m_value;
}

QString WorKflow::Result::linkedParameter( ) const
{
  return m_linkedParameter;
}
