/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

// WorKflow includes
#include "mainwindow.h"
#include "applicationmanager.h"

static const char description[] = I18N_NOOP("Automates the Desktop");

static const char version[] = "0.1";

static KCmdLineOptions options[] =
{
  { "+[URL]", I18N_NOOP("Document to open"), 0 },
  { "appid <id>", I18N_NOOP("The ID of the application to take control of"), 0 },
  { "dcop <name>", I18N_NOOP("The DCOP name of the application to take control of"), 0 },
  { "execute", I18N_NOOP("Just execute the specified workflow"), 0 },
  KCmdLineLastOption
};

int main(int argc, char **argv)
{
  KAboutData about("workflow", I18N_NOOP("WorKflow"), version, description,
                   KAboutData::License_GPL, "(C) 2006 Thomas Kadauke", 0, 0, "tkadauke@gmx.de");
  about.addAuthor( "Thomas Kadauke", 0, "tkadauke@gmx.de" );
  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions(options);
  KApplication app;

  // register ourselves as a dcop client
  app.dcopClient()->registerAs(app.name(), false);

  // see if we are starting with session management
  if (app.isRestored()) {
    RESTORE(MainWindow);
  } else {
    // no session.. just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    QCString appid = args->getOption("appid");
    QCString dcop = args->getOption("dcop");

    if (!appid.isNull() && !dcop.isNull()) {
      WorKflow::ApplicationManager::setMainApplication(appid, dcop);
    }

    if (args->count() == 0) {
      MainWindow *widget = new MainWindow;
      widget->show();
    } else {
      int i = 0;
      for (; i < args->count(); i++) {
        MainWindow *widget = new MainWindow;
        widget->openOnStartup(args->url(i), args->isSet("execute"));
        if (!args->isSet("execute"))
          widget->show();
      }
    }
    args->clear();
  }

  return app.exec();
}
