/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef COMMANDDIALOG_H
#define COMMANDDIALOG_H

// designer includes
#include "commanddialogbase.h"

// forward declarations
namespace WorKflow
{
  class CommandDescription;
  class LibraryDescription;
}

class CommandDialog : public CommandDialogBase
{
  Q_OBJECT

public:
  static bool editCommand(QWidget* parent, WorKflow::CommandDescription* desc);
  static WorKflow::CommandDescription* newCommand(QWidget* parent, WorKflow::LibraryDescription* library);

protected:
  CommandDialog(QWidget* parent, WorKflow::CommandDescription* desc);
  ~CommandDialog();

  void init();
  void initGeneralTab();
  void initKeywordsTab();
  void initGuiTab();

protected slots:
  virtual void accept();

  virtual void addKeyword();
  virtual void removeKeyword();
  virtual void slotKeywordSelectionChanged();
  virtual void updateKeyword();
  virtual void editUiFile();

private:
  WorKflow::CommandDescription* m_description;
};

#endif

