/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef COMMANDLISTVIEW_H
#define COMMANDLISTVIEW_H

// KDE includes
#include <klistview.h>

// forward declarations
namespace WorKflow
{
  class CommandDescription;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class CommandListView : public KListView
  {
    Q_OBJECT

  public:
    CommandListView(QWidget* parent = 0, const char* name = 0);
    ~CommandListView();

    QString category();

  signals:
    void executed(const QString& command);
    void selected(CommandDescription* desc);

  public slots:
    void setCategory(const QString& category);

  protected:
    void populate();

    virtual QDragObject* dragObject();

  private slots:
    void slotExecuted(QListViewItem* item);
    void slotSelectionChanged(QListViewItem* item);

  private:
    QString m_category;
  };
}

#endif
