/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klistview.h>

// command includes
#include "askforkatedocumentsdialog.h"
#include "kateapplication.h"

bool AskForKateDocumentsDialog::select(QWidget* parent, KateApplication* app, bool multiple, bool empty, DocumentList& documents)
{
  AskForKateDocumentsDialog dialog(parent, app, multiple, empty);
  if (dialog.exec()) {
    documents = dialog.selected();
    return true;
  } else
    return false;
}

AskForKateDocumentsDialog::AskForKateDocumentsDialog(QWidget* parent, KateApplication* app, bool multiple, bool empty)
  : AskForKateDocumentsDialogBase(parent), m_application(app), m_allowMultiple(multiple), m_allowEmpty(empty)
{
  init();
}

AskForKateDocumentsDialog::~AskForKateDocumentsDialog()
{
}

void AskForKateDocumentsDialog::init()
{
//   DocumentList docs = m_application->documents();
  
}

AskForKateDocumentsDialog::DocumentList AskForKateDocumentsDialog::selected()
{
  QListViewItemIterator it(m_listView);
  while (it.current()) {

  }
}

#include "askforkatedocumentsdialog.moc"
