/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#include "katedocument.h"

KateDocument::KateDocument(DCOPRef doc)
  : m_dcopRef(doc)
{
}

KateDocument::~KateDocument()
{
}

DCOPRef KateDocument::dcopRef()
{
  return m_dcopRef;
}

DCOPRef KateDocument::selection()
{
  // for some strange reason, there are two SelectionInterfaces per Kate document ...
  QString selectionIface = QString("SelectionInterface#%1").arg(documentNumber() * 2 - 1);
  return DCOPRef(m_dcopRef.app(), selectionIface.utf8());
}

DCOPRef KateDocument::editor()
{
  QString editIface = QString("EditInterface#%1").arg(documentNumber());
  return DCOPRef(m_dcopRef.app(), editIface.utf8());
}

DCOPRef KateDocument::view()
{
  uint num = documentNumber();
  QString viewIface = QString("ViewCursorInterface#%1-%2").arg(num).arg(num);
  return DCOPRef(m_dcopRef.app(), viewIface.utf8());
}

uint KateDocument::documentNumber()
{
  uint num = m_dcopRef.call("documentNumber()");
  return num;
}
