/***************************************************************************
 *   Copyright (C) 2005 by Piotr Szymanski <niedakh@gmail.com>             *
 *                                                                         *
 * This library is free software; you can redistribute it and/or           *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 2.1 of the License, or (at your option) any later version.      *
 *                                                                         *
 * This library is distributed in the hope that it will be useful,         *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * Lesser General Public License for more details.                         *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with this library; if not, write to the Free Software     *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,                  *
 * MA  02110-1301  USA                                                     *
 ***************************************************************************/

#include <qstringlist.h>
#include <qapplication.h>
#include <qdebug.h>
#include <qgs.h>
#include <iostream>

/*
 *	Example of not using the GUI and the default arguments - getting a DSC document describing a PDF.
 */
int main (int argc, char* argv[])
{
	try
	{
		QApplication(argc,argv);
		if (argc<3)
		{
			std::cout << "Usage " << QLatin1String(argv[0]).latin1() << " PDFfile OutputFileForDSC\n";
			return -1;
		}
		GSInterpreterLib interpreter;
		QStringList arg;
		arg << " "
		<< "-q"
		<< "-dPARANOIDSAFER"
		<< "-dSAFER"
		<< "-dDELAYSAFER"
		<< "-dNODISPLAY"
		<< "-dQUIET"
		<< QString("-sPDFname=%1").arg(argv[1])
		<< QString("-sDSCname=%1").arg(argv[2])
		<< "-c '<< /PermitFileReading [ InputFile ] /PermitFileWriting [] /PermitFileControl [] >> setuserparams .locksafe'"
		<< "-f pdf2dsc.ps"
		<< "-c quit";
		interpreter.setDisplay(false);
		interpreter.setGhostscriptArguments(arg);
		interpreter.start(false);
	}
	catch (GSInterpreterLib::GSError& ex)
	{
		qDebug() << ex.name << endl;
	}
	return 0;
}
