/*
   SPDX-FileCopyrightText: 2017-2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "testselectionchangedwebengine.h"

#include <QApplication>
#include <QVBoxLayout>
#include <webengineview.h>
#include <QTextEdit>
#include <QDebug>

TestSelectionChangedEngine::TestSelectionChangedEngine(QWidget *parent)
    : QWidget(parent)
{
    QVBoxLayout *vbox = new QVBoxLayout(this);
    QHBoxLayout *layout = new QHBoxLayout;
    vbox->addLayout(layout);
    pageView = new WebEngineViewer::WebEngineView(this);
    pageView->load(QUrl(QStringLiteral("http://www.planetkde.org")));
    connect(pageView, &WebEngineViewer::WebEngineView::selectionChanged, this, &TestSelectionChangedEngine::slotSelectionChanged);
    layout->addWidget(pageView);

    QTextEdit *edit = new QTextEdit(this);
    vbox->addWidget(edit);
}

TestSelectionChangedEngine::~TestSelectionChangedEngine()
{
}

void TestSelectionChangedEngine::slotSelectionChanged()
{
    qDebug() << " void TestSelectionChangedEngine::slotSelectionChanged()";
}

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setAttribute(Qt::AA_UseHighDpiPixmaps, true);
    TestSelectionChangedEngine *testWebEngine = new TestSelectionChangedEngine;
    testWebEngine->show();
    const int ret = app.exec();
    return ret;
}
