/*
    This file is part of KOrganizer.
    Copyright (c) 2003 Bo Thorsen  <bo@klaralvdalens-datakonsult.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#ifndef _INCIDENCECONFLICTDIALOG_H
#define _INCIDENCECONFLICTDIALOG_H

#include <qdialog.h>

class QTextEdit;
class QLabel;
namespace KCal {
  class Incidence;
};


class IncidenceConflictDialog : public QDialog
{
  Q_OBJECT

public:
  IncidenceConflictDialog( QWidget* parent=0, const char* name=0,
			   bool modal=false, WFlags f=0 );
  ~IncidenceConflictDialog();

  void setIncidences( KCal::Incidence* newIncidence, KCal::Incidence* oldIncidence );

  // Get the users choice. 0: Keep both; 1: Keep new; 2: Keep old
  int choice() const { return mChoice; }

private slots:
  void slotKeepLocal();
  void slotKeepServer();

private:
  void setLabel( const QCString& incidenceType );

  int mChoice;

  QTextEdit* tab1;
  QTextEdit* tab2;
  QLabel* label;
};


#endif /* _INCIDENCECONFLICTDIALOG_H */

