<?php
/**
 * $Horde: horde/deletelink.php,v 1.6 2003/04/20 20:50:34 chuck Exp $
 *
 * Generic delete API for Horde_Links 
 *
 * Copyright 2003, Jeroen Huinink <j.huinink@wanadoo.nl>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Links.php';
$links = &Horde_Links::singleton($registry->getApp());

if (!Auth::isAuthenticated()) {
    Horde::authenticationFailureRedirect();
}

$from_application = Horde::getFormData('from_application');
$from_parameters = @unserialize(Horde::getFormData('from_parameters'));
$to_application = Horde::getFormData('to_application');
$to_parameters = @unserialize(Horde::getFormData('to_parameters'));
$link_type = Horde::getFormData('link_type');
$return_url = Horde::getFormData('return_url');

$result = $links->deleteLink($from_application, $from_parameters, $to_application,
                             $to_parameters, $link_type);
if (is_a($result, 'PEAR_Error')) {
    $notification->push($result, 'horde.error');
} elseif ($registry->hasMethod($to_application . '/getLinkSummary')) {
    $summary = $registry->call($to_application. '/getLinkSummary', $to_parameters);
    if (is_a($summary, 'PEAR_Error')) {
        $summary = $summary->getMessage();
    }
    $notification->push(sprintf(_("The %s link to %s has been removed."), $link_type, $summary),
                        'horde.success');
} else {
    $notification->push(_("The link has been removed"), 'horde.success');
}

header('Location: ' . $return_url);
