<?php
/**
 * Implementation of the Quota API for Courier IMAP servers.
 *
 * $Horde: imp/lib/Quota/courier.php,v 1.17 2003/06/04 14:19:05 jan Exp $
 *
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.17 $
 * @since   IMP 4.0
 * @package imp.quota
 */
class IMP_Quota_courier extends IMP_Quota {

    /**
     * Get quota HTML to push to user.
     *
     * @access public
     *
     * @return string  The HTML representation of the quota data.
     */
    function quotaHTML()
    {
        $quota = null;

        if (function_exists('imap_get_quotaroot')) {
            @$quota = imap_get_quotaroot($_SESSION['imp']['stream'], 'INBOX');
        } else {
            require_once IMP_BASE . '/lib/IMAP.php';
            $imp_imap = &IMP_IMAP::singleton();
            $stream = $imp_imap->openIMAPStream(null, OP_HALFOPEN);

            if ($stream !== false) {
                $quota = @imap_get_quota($stream, 'ROOT');
                @imap_close($stream);
            }
        }
        if (is_array($quota) && !empty($quota)) {
            if (!empty($quota['limit'])) {
                return $this->_quotaHTML($quota['usage'] * 1024, $quota['limit'] * 1024);
            } elseif (!empty($quota['STORAGE']['limit'])) {
                return $this->_quotaHTML($quota['STORAGE']['usage'] * 1024, $quota['STORAGE']['limit'] * 1024);
            }
            return $this->_quotaHTML(0, 0);
        }

        return $this->_quotaError(_("Unable to retrieve quota"));
    }

}
