<?php
/**
 * $Horde: mnemo/notepads.php,v 1.12 2003/05/23 13:21:27 chuck Exp $
 *
 * Copyright 2002-2003 Joel Vandal <jvandal@infoteck.qc.ca>
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('SHARE_EDIT',   1);
define('SHARE_SAVE',   2);
define('SHARE_DELETE', 3);
define('SHARE_ACCESS', 4);
define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';

// Exit if this isn't an authenticated user.
if (!Auth::getAuth()) {
    require MNEMO_BASE . '/list.php';
    exit;
}

$to_edit = null;
$onlynew = 0;
$actionID = Horde::getFormData('actionID');

// Handle clients without javascript.
if (is_null($actionID)) {
    if (isset($_POST['edit'])) {
        $actionID = SHARE_EDIT;
    } elseif (isset($_POST['save'])) {
        $actionID = SHARE_SAVE;
    } elseif (isset($_POST['delete'])) {
        $actionID = SHARE_DELETE;
    } elseif (isset($_POST['accesslist'])) {
        $actionID = SHARE_ACCESS;
    } elseif (isset($_POST['back'])) {
        header('Location: ' . Horde::applicationUrl('prefs.php', true));
        exit;
    }
}

/* Run through the action handlers */
switch ($actionID) {
 case SHARE_EDIT:
    $to_edit = Horde::getFormData('share');
    break;

 case SHARE_SAVE:
    $to_edit = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');
    if (empty($id)) {
        $notification->push(_("The notepad name is empty."), 'horde.error');
        break;
    }

    $notepad = '';
    if (!isset($to_edit) || $to_edit == '') {
        /* Create New Share */
        $notepad = $GLOBALS['mnemo_shares']->newShare(md5(microtime()));
        $notepad->setOwner(Auth::getAuth(), false);
        $notepad->setShareName($id, false);
        $notepad->setType(Horde::getFormData('type', 0), false);
        $notepad->setDescription(Horde::getFormData('description', ''), false);
        $result = $GLOBALS['mnemo_shares']->addShare($notepad);

        if (is_a($result, 'PEAR_Error')) {
            $notification->push(sprintf(_("The notepad \"%s\" couldn't be created: %s"), $id, $result->getMessage()), 'horde.error');
        } else {
            $notification->push(sprintf(_("The notepad \"%s\" has been created."), $id), 'horde.success');
        }
    } else {
        $notepad = &$GLOBALS['mnemo_shares']->getShare($to_edit);
        $notepad->setShareName($id, false);
        $notepad->setType(Horde::getFormData('type', 0), false);
        $notepad->setDescription(Horde::getFormData('description', ''));

        $notification->push(sprintf(_("The notepad \"%s\" has been saved."), $id), 'horde.success');
    }

    unset($to_edit);
    break;

 case SHARE_DELETE:
    $to_delete = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');

    if (isset($to_delete)) {
        $share = $GLOBALS['mnemo_shares']->getShare($to_delete);

        // Delete the notepad.
        require_once MNEMO_BASE . '/lib/Driver.php';
        $storage = &Mnemo_Driver::factory($conf['storage']['driver'], $to_delete,
                                        $conf['storage']['params']);
        $storage->retrieve();
        $storage->deleteAll();
        $res = $storage->store();

        if (PEAR::isError($res)) {
            $notification->push(sprintf(_("Unable to delete \"%s\": %s"), $share->getShareName(), $res->getMessage()), 'horde.error');
        } else {
            // Remove share and all groups/permissions.
            $GLOBALS['mnemo_shares']->removeShare($share);
            $notification->push(sprintf(_("The notepad \"%s\" has been deleted."), $share->getShareName()), 'horde.success');
        }
    } else {
        $notification->push(_("You must select a notepad to be deleted."), 'horde.warning');
    }

    // Make sure we still on at least one notepad
    if (count(Mnemo::listNotepads(true)) == 0) {
        /* If this share doesn't exist then create it */
        if (!$GLOBALS['mnemo_shares']->exists(Auth::getAuth())) {
            $share = $GLOBALS['mnemo_shares']->newShare(Auth::getAuth());
            $share->setOwner(Auth::getAuth());
            $share->setShareName(_("My Notepad"));
            $GLOBALS['mnemo_shares']->addShare($share);
        }
    }
    break;

 case SHARE_ACCESS:
    $edit_share = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');
    $type = Horde::getFormData('type');

    if ($type == 1) {
        header('Location: ' . Horde::applicationUrl('notepads/members.php?edit_share=' . $edit_share, true));
    }
    break;
}

$title = _("Note Lists");

/* Personal Note Lists */
$personal_notepads = Mnemo::listNotepads(true);

require MNEMO_TEMPLATES . '/common-header.inc';
require_once $registry->getParam('templates', 'horde') . '/javascript/open_share_edit_win.js';
Mnemo::menu();
require MNEMO_TEMPLATES . '/notepads/javascript.inc';
require MNEMO_TEMPLATES . '/notepads/manage.inc';
require MNEMO_TEMPLATES . '/common-footer.inc';
