<?php
/**
 * $Horde: nag/tasklists.php,v 1.14 2003/08/18 14:21:40 jwm Exp $
 *
 * Copyright 2002-2003 Joel Vandal <jvandal@infoteck.qc.ca>
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('SHARE_EDIT',   1);
define('SHARE_SAVE',   2);
define('SHARE_DELETE', 3);
define('SHARE_ACCESS', 4);
define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';

// Exit if this isn't an authenticated user.
if (!Auth::getAuth()) {
    require NAG_BASE . '/list.php';
    exit;
}

$to_edit = null;
$onlynew = 0;
$actionID = Horde::getFormData('actionID');

// Handle clients without javascript.
if (is_null($actionID)) {
    if (isset($_POST['edit'])) {
        $actionID = SHARE_EDIT;
    } elseif (isset($_POST['save'])) {
        $actionID = SHARE_SAVE;
    } elseif (isset($_POST['delete'])) {
        $actionID = SHARE_DELETE;
    } elseif (isset($_POST['accesslist'])) {
        $actionID = SHARE_ACCESS;
    } elseif (isset($_POST['back'])) {
        header('Location: ' . Horde::applicationUrl('prefs.php', true));
        exit;
    }
}

/* Run through the action handlers */
switch ($actionID) {
 case SHARE_EDIT:
    $to_edit = Horde::getFormData('share');
    break;

 case SHARE_SAVE:
    $to_edit = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');
    if (empty($id)) {
        $notification->push(_("The task list name is empty."), 'horde.error');
        break;
    }

    $tasklist = '';
    if (!isset($to_edit) || $to_edit == '') {
        /* Create New Share */
        $tasklist = $GLOBALS['nag_shares']->newShare(md5(microtime()));
        if (is_a($tasklist, 'PEAR_Error')) {
            $result = &$tasklist;
        } else {
            $tasklist->setOwner(Auth::getAuth(), false);
            $tasklist->setShareName($id, false);
            $tasklist->setType(Horde::getFormData('type', 0), false);
            $tasklist->setDescription(Horde::getFormData('description', ''), false);
            $result = $GLOBALS['nag_shares']->addShare($tasklist);
        }

        if (is_a($result, 'PEAR_Error')) {
            $notification->push(sprintf(_("The task list \"%s\" couldn't be created: %s"), $id, $result->getMessage()), 'horde.error');
        } else {
            $notification->push(sprintf(_("The task list \"%s\" has been created."), $id), 'horde.success');
        }
    } else {
        $tasklist = &$GLOBALS['nag_shares']->getShare($to_edit);
        $tasklist->setShareName($id, false);
        $tasklist->setType(Horde::getFormData('type', 0), false);
        $result = $tasklist->setDescription(Horde::getFormData('description', ''));

        if (is_a($result, 'PEAR_Error')) {
            $notification->push(sprintf(_("The task list \"%s\" couldn't be saved: %s"), $id, $result->getMessage()), 'horde.error');
        } else {
            $notification->push(sprintf(_("The task list \"%s\" has been saved."), $id), 'horde.success');
        }
    }

    unset($to_edit);
    break;

 case SHARE_DELETE:
    $to_delete = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');

    if (isset($to_delete)) {
        $share = $GLOBALS['nag_shares']->getShare($to_delete);

        // Delete the tasklist.
        require_once NAG_BASE . '/lib/Driver.php';
        $storage = &Nag_Driver::factory($conf['storage']['driver'], $to_delete,
                                        $conf['storage']['params']);
        $storage->retrieve();
        $storage->deleteAll();

        if (PEAR::isError($storage->store())) {
            $notification->push(sprintf(_("Unable to delete \"%s\": %s"), $share->getShareName(), $res->getMessage()), 'horde.error');
        } else {
            // Remove share and all groups/permissions.
            $GLOBALS['nag_shares']->removeShare($share);
            $notification->push(sprintf(_("The task list \"%s\" has been deleted."), $share->getShareName()), 'horde.success');
        }
    } else {
        $notification->push(_("You must select a task list to be deleted."), 'horde.warning');
    }

    /* Make sure we still have at least one task list. */
    if (count(Nag::listTasklists(true)) == 0) {
        /* Create the share if it doesn't exist, on a best-effort basis. */
        if (!$GLOBALS['nag_shares']->exists(Auth::getAuth())) {
            $share = $GLOBALS['nag_shares']->newShare(Auth::getAuth());
            $share->setOwner(Auth::getAuth(), false);
            $share->setShareName(_("My Task List"));
            $GLOBALS['nag_shares']->addShare($share);
        }
    }
    break;

 case SHARE_ACCESS:
    $edit_share = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');
    $type = Horde::getFormData('type');

    if ($type == 1) {
        header('Location: ' . Horde::applicationUrl('tasklists/members.php?edit_share=' . $edit_share, true));
    }
    break;
}

$title = _("Task Lists");
$js_onLoad = null;

/* Personal Task Lists */
$personal_tasklists = Nag::listTasklists(true);

require NAG_TEMPLATES . '/common-header.inc';
require_once $registry->getParam('templates', 'horde') . '/javascript/open_share_edit_win.js';
Nag::menu();
require NAG_TEMPLATES . '/tasklists/javascript.inc';
require NAG_TEMPLATES . '/tasklists/manage.inc';
require NAG_TEMPLATES . '/common-footer.inc';
