<?php
/**
 * $Horde: horde/shares/edit.php,v 1.11 2003/06/26 18:07:28 chuck Exp $
 *
 * Copyright 2002-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

$fieldsList['show'] = 0;
$fieldsList['read'] = 1;
$fieldsList['edit'] = 2;
$fieldsList['delete'] = 3;

define('HORDE_BASE', dirname(__FILE__) . '/..');

require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Menu.php';
require_once HORDE_BASE . '/lib/Share.php';
require_once HORDE_BASE . '/lib/Group.php';

Horde::compressOutput();

$app = Horde::getFormData('app');
$shares = &Horde_Share::singleton($app);
$groups = &Group::singleton();
$auth = &Auth::singleton($conf['auth']['driver']);

$form = null;
$reload = false;
$actionID = Horde::getFormData('actionID', 'edit');
switch ($actionID) {

case 'edit':
    $share = &$shares->getShareById(Horde::getFormData('cid'));
    if (!is_a($share, 'PEAR_Error')) {
        $form = 'edit.inc';
        $perm = &$share->getPermission();
    } elseif (($category = Horde::getFormData('share')) !== null) {
        $share = &$shares->getShare($category);
        if (!is_a($share, 'PEAR_Error')) {
            $form = 'edit.inc';
            $perm = &$share->getPermission();
        }
    }
    if (is_a($share, 'PEAR_Error')) {
        $notification->push($share, 'horde.error');
    } elseif (isset($share) && Auth::getAuth() != $share->getOwner()) {
        exit('permission denied');
    }
    break;

case 'editform':
    $share = &$shares->getShareById(Horde::getFormData('cid'));
    if (is_a($share, 'PEAR_Error')) {
        $notification->push(_("Attempt to edit a non-existent share."), 'horde.error');
    } else {
        if (Auth::getAuth() != $share->getOwner()) {
            exit('permission denied');
        }
        $perm = &$share->getPermission();

        // Process owner and owner permissions.
        $old_owner = $share->getOwner();
        $new_owner = Horde::getFormData('owner', $old_owner);
        if ($old_owner !== $new_owner && !empty($new_owner)) {
            if ($old_owner != Auth::getAuth() && !Auth::isAdmin()) {
                $notification->push(_("Only the owner or system administrator may change ownership or owner permissions for a share"), 'horde.error');
            } else {
                $share->setOwner($new_owner);
                if (Horde::getFormData('owner_show')) {
                    $perm->addUserPermission($new_owner, _PERMS_SHOW, false);
                } else {
                    $perm->removeUserPermission($new_owner, _PERMS_SHOW, false);
                }                            
                if (Horde::getFormData('owner_read')) {
                    $perm->addUserPermission($new_owner, _PERMS_READ, false);
                } else {
                    $perm->removeUserPermission($new_owner, _PERMS_READ, false);
                }                            
                if (Horde::getFormData('owner_edit')) {
                    $perm->addUserPermission($new_owner, _PERMS_EDIT, false);
                } else {
                    $perm->removeUserPermission($new_owner, _PERMS_EDIT, false);
                }                            
                if (Horde::getFormData('owner_delete')) {
                    $perm->addUserPermission($new_owner, _PERMS_DELETE, false);
                } else {
                    $perm->removeUserPermission($new_owner, _PERMS_DELETE, false);
                }                            
            }
        }

        // Process default permissions.
        if (Horde::getFormData('default_show')) {
            $perm->addDefaultPermission(_PERMS_SHOW, false);
        } else {
            $perm->removeDefaultPermission(_PERMS_SHOW, false);
        }
        if (Horde::getFormData('default_read')) {
            $perm->addDefaultPermission(_PERMS_READ, false);
        } else {
            $perm->removeDefaultPermission(_PERMS_READ, false);
        }
        if (Horde::getFormData('default_edit')) {
            $perm->addDefaultPermission(_PERMS_EDIT, false);
        } else {
            $perm->removeDefaultPermission(_PERMS_EDIT, false);
        }
        if (Horde::getFormData('default_delete')) {
            $perm->addDefaultPermission(_PERMS_DELETE, false);
        } else {
            $perm->removeDefaultPermission(_PERMS_DELETE, false);
        }

        // Process guest permissions.
        if (Horde::getFormData('guest_show')) {
            $perm->addGuestPermission(_PERMS_SHOW, false);
        } else {
            $perm->removeGuestPermission(_PERMS_SHOW, false);
        }
        if (Horde::getFormData('guest_read')) {
            $perm->addGuestPermission(_PERMS_READ, false);
        } else {
            $perm->removeGuestPermission(_PERMS_READ, false);
        }
        if (Horde::getFormData('guest_edit')) {
            $perm->addGuestPermission(_PERMS_EDIT, false);
        } else {
            $perm->removeGuestPermission(_PERMS_EDIT, false);
        }
        if (Horde::getFormData('guest_delete')) {
            $perm->addGuestPermission(_PERMS_DELETE, false);
        } else {
            $perm->removeGuestPermission(_PERMS_DELETE, false);
        }

        // Process creator permissions.
        if (Horde::getFormData('creator_show')) {
            $perm->addCreatorPermission(_PERMS_SHOW, false);
        } else {
            $perm->removeCreatorPermission(_PERMS_SHOW, false);
        }
        if (Horde::getFormData('creator_read')) {
            $perm->addCreatorPermission(_PERMS_READ, false);
        } else {
            $perm->removeCreatorPermission(_PERMS_READ, false);
        }
        if (Horde::getFormData('creator_edit')) {
            $perm->addCreatorPermission(_PERMS_EDIT, false);
        } else {
            $perm->removeCreatorPermission(_PERMS_EDIT, false);
        }
        if (Horde::getFormData('creator_delete')) {
            $perm->addCreatorPermission(_PERMS_DELETE, false);
        } else {
            $perm->removeCreatorPermission(_PERMS_DELETE, false);
        }

        // Process user permissions.
        $u_names = Horde::getFormData('u_names');
        $u_show = Horde::getFormData('u_show');
        $u_read = Horde::getFormData('u_read');
        $u_edit = Horde::getFormData('u_edit');
        $u_delete = Horde::getFormData('u_delete');

        foreach ($u_names as $key => $user) {
            // If the user is empty, or we've already set permissions via
            // the owner_ options, don't do anything here.
            if (empty($user) || $user == $new_owner) {
                continue;
            }

            if (!empty($u_show[$key])) {
                $perm->addUserPermission($user, _PERMS_SHOW, false);
            } else {
                $perm->removeUserPermission($user, _PERMS_SHOW, false);
            }
            if (!empty($u_read[$key])) {
                $perm->addUserPermission($user, _PERMS_READ, false);
            } else {
                $perm->removeUserPermission($user, _PERMS_READ, false);
            }
            if (!empty($u_edit[$key])) {
                $perm->addUserPermission($user, _PERMS_EDIT, false);
            } else {
                $perm->removeUserPermission($user, _PERMS_EDIT, false);
            }
            if (!empty($u_delete[$key])) {
                $perm->addUserPermission($user, _PERMS_DELETE, false);
            } else {
                $perm->removeUserPermission($user, _PERMS_DELETE, false);
            }
        }

        // Process group permissions.
        $g_names = Horde::getFormData('g_names');
        $g_show = Horde::getFormData('g_show');
        $g_read = Horde::getFormData('g_read');
        $g_edit = Horde::getFormData('g_edit');
        $g_delete = Horde::getFormData('g_delete');

        foreach ($g_names as $key => $group) {
            if (empty($group)) {
                continue;
            }

            if (!empty($g_show[$key])) {
                $perm->addGroupPermission($group, _PERMS_SHOW, false);
            } else {
                $perm->removeGroupPermission($group, _PERMS_SHOW, false);
            }
            if (!empty($g_read[$key])) {
                $perm->addGroupPermission($group, _PERMS_READ, false);
            } else {
                $perm->removeGroupPermission($group, _PERMS_READ, false);
            }
            if (!empty($g_edit[$key])) {
                $perm->addGroupPermission($group, _PERMS_EDIT, false);
            } else {
                $perm->removeGroupPermission($group, _PERMS_EDIT, false);
            }
            if (!empty($g_delete[$key])) {
                $perm->addGroupPermission($group, _PERMS_DELETE, false);
            } else {
                $perm->removeGroupPermission($group, _PERMS_DELETE, false);
            }
        }

        $share->setPermission($perm);
        $share->save();
        $notification->push(sprintf(_("Updated '%s'."), $share->getShareName()), 'horde.success');
        $form = 'edit.inc';
    }
    break;
}

if (is_a($share, 'PEAR_Error')) {
    $title = _("Edit Permissions");
} else {
    $title = sprintf(_("Edit Permissions for %s"), $share->getShareName());
}

$userList = $auth->listUsers();
if (is_a($userList, 'PEAR_Error')) {
    Horde::logMessage($userList, __FILE__, __LINE__, PEAR_LOG_NOTICE);
    $userList = array();
}
$groupList = $groups->listGroups();
if (is_a($groupList, 'PEAR_Error')) {
    Horde::logMessage($groupList, __FILE__, __LINE__, PEAR_LOG_NOTICE);
    $groupList = array();
}

require HORDE_TEMPLATES . '/common-header.inc';
$notification->notify();
if (!empty($form)) {
    require HORDE_TEMPLATES . '/shares/' . $form;
}

require HORDE_TEMPLATES . '/common-footer.inc';
