/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegrationLinkageException;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.internal.LibraryDef;
import net.rubygrapefruit.platform.internal.NativeLibraryLocator;
import net.rubygrapefruit.platform.internal.Platform;

public class NativeLibraryLoader {
    private final Set<String> loaded = new HashSet<String>();
    private final Platform platform;
    private final NativeLibraryLocator nativeLibraryLocator;

    public NativeLibraryLoader(Platform platform, NativeLibraryLocator nativeLibraryLocator) {
        this.platform = platform;
        this.nativeLibraryLocator = nativeLibraryLocator;
    }

    public void load(String libraryFileName, List<String> platforms) {
        if (this.loaded.contains(libraryFileName)) {
            return;
        }
        try {
            UnsatisfiedLinkError loadFailure = null;
            for (String platformId : platforms) {
                File libFile = this.nativeLibraryLocator.find(new LibraryDef(libraryFileName, platformId));
                if (libFile == null) continue;
                try {
                    System.load(libFile.getCanonicalPath());
                }
                catch (UnsatisfiedLinkError e) {
                    loadFailure = e;
                    continue;
                }
                this.loaded.add(libraryFileName);
                return;
            }
            if (loadFailure != null) {
                throw new NativeIntegrationLinkageException(String.format("Native library '%s' could not be loaded for %s.", libraryFileName, this.platform), loadFailure);
            }
            throw new NativeIntegrationUnavailableException(String.format("Native library '%s' is not available for %s.", libraryFileName, this.platform));
        }
        catch (NativeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new NativeException(String.format("Failed to load native library '%s' for %s.", libraryFileName, this.platform), t);
        }
    }
}

