/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;

public class ConstructorPart {
    private final String name;
    private final Boolean required;

    protected ConstructorPart(BuilderImpl builder) {
        this.name = builder.name();
        this.required = builder.required();
    }

    public String name() {
        return this.name;
    }

    public Boolean required() {
        return this.required;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String name;
        protected Boolean required;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConstructorPart model) {
            this.name = model.name();
            this.required = model.required();
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public Boolean required() {
            return this.required;
        }

        @Override
        public ConstructorPart build() {
            if (Objects.isNull(this.name())) {
                throw new IllegalArgumentException("Missing value for required field `name`");
            }
            if (Objects.isNull(this.required())) {
                throw new IllegalArgumentException("Missing value for required field `required`");
            }
            return new ConstructorPart(this);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public String name();

        public Builder required(Boolean var1);

        public Boolean required();

        public ConstructorPart build();
    }
}

