/*
 * Decompiled with CFR 0.152.
 */
package Base64_Compile;

import Base64_Compile.index;
import BoundedInts_Compile.uint8;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;

public class __default {
    public static boolean IsBase64Char(char c) {
        return c == '+' || c == '/' || '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    public static boolean IsUnpaddedBase64String(DafnySequence<? extends Character> s) {
        boolean _hresult = false;
        long _0_size = s.cardinalityInt();
        if (Long.remainderUnsigned(_0_size, 4L) != 0L) {
            _hresult = false;
            return _hresult;
        }
        long _hi0 = _0_size;
        long _1_i = 0L;
        while (Long.compareUnsigned(_1_i, _hi0) < 0) {
            if (!__default.IsBase64Char(((Character)s.select(Helpers.unsignedToInt((long)_1_i))).charValue())) {
                _hresult = false;
                return _hresult;
            }
            ++_1_i;
        }
        _hresult = true;
        return _hresult;
    }

    public static char IndexToChar(byte i) {
        if (i == 63) {
            return '/';
        }
        if (i == 62) {
            return '+';
        }
        if (Integer.compareUnsigned(52, i) <= 0 && Integer.compareUnsigned(i, 61) <= 0) {
            return (char)Byte.toUnsignedInt((byte)(i - 4));
        }
        if (Integer.compareUnsigned(26, i) <= 0 && Integer.compareUnsigned(i, 51) <= 0) {
            return (char)Byte.toUnsignedInt((byte)(i + 71));
        }
        return (char)Byte.toUnsignedInt((byte)(i + 65));
    }

    public static byte CharToIndex(char c) {
        if (c == '/') {
            return 63;
        }
        if (c == '+') {
            return 62;
        }
        if ('0' <= c && c <= '9') {
            return (byte)((byte)c + 4);
        }
        if ('a' <= c && c <= 'z') {
            return (byte)((byte)c - 71);
        }
        return (byte)((byte)c - 65);
    }

    public static DafnySequence<? extends Byte> UInt24ToSeq(int x) {
        byte _0_b0 = (byte)Integer.divideUnsigned(x, 65536);
        int _1_x0 = x - Byte.toUnsignedInt(_0_b0) * 65536;
        byte _2_b1 = (byte)Integer.divideUnsigned(_1_x0, 256);
        byte _3_b2 = (byte)Integer.remainderUnsigned(_1_x0, 256);
        return DafnySequence.of((byte[])new byte[]{_0_b0, _2_b1, _3_b2});
    }

    public static int SeqToUInt24(DafnySequence<? extends Byte> s) {
        return Byte.toUnsignedInt((Byte)s.select(0)) * 65536 + Byte.toUnsignedInt((Byte)s.select(1)) * 256 + Byte.toUnsignedInt((Byte)s.select(2));
    }

    public static int SeqPosToUInt24(DafnySequence<? extends Byte> s, long pos) {
        return Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)pos))) * 65536 + Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 1L)))) * 256 + Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 2L))));
    }

    public static DafnySequence<? extends Byte> UInt24ToIndexSeq(int x) {
        byte _0_b0 = (byte)Integer.divideUnsigned(x, 262144);
        int _1_x0 = x - Byte.toUnsignedInt(_0_b0) * 262144;
        byte _2_b1 = (byte)Integer.divideUnsigned(_1_x0, 4096);
        int _3_x1 = _1_x0 - Byte.toUnsignedInt(_2_b1) * 4096;
        byte _4_b2 = (byte)Integer.divideUnsigned(_3_x1, 64);
        byte _5_b3 = (byte)Integer.remainderUnsigned(_3_x1, 64);
        return DafnySequence.of((byte[])new byte[]{_0_b0, _2_b1, _4_b2, _5_b3});
    }

    public static int IndexSeqToUInt24(DafnySequence<? extends Byte> s) {
        return Byte.toUnsignedInt((Byte)s.select(0)) * 262144 + Byte.toUnsignedInt((Byte)s.select(1)) * 4096 + Byte.toUnsignedInt((Byte)s.select(2)) * 64 + Byte.toUnsignedInt((Byte)s.select(3));
    }

    public static int IndexSeqPosToUInt24(DafnySequence<? extends Byte> s, long pos) {
        return Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)pos))) * 262144 + Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 1L)))) * 4096 + Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 2L)))) * 64 + Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 3L))));
    }

    public static DafnySequence<? extends Byte> DecodeBlock(DafnySequence<? extends Byte> s) {
        return __default.UInt24ToSeq(__default.IndexSeqToUInt24(s));
    }

    public static DafnySequence<? extends Byte> DecodeBlockPos(DafnySequence<? extends Byte> s, long pos) {
        return __default.UInt24ToSeq(__default.IndexSeqPosToUInt24(s, pos));
    }

    public static DafnySequence<? extends Byte> EncodeBlock(DafnySequence<? extends Byte> s) {
        return __default.UInt24ToIndexSeq(__default.SeqToUInt24(s));
    }

    public static DafnySequence<? extends Byte> EncodeBlockPos(DafnySequence<? extends Byte> s, long pos) {
        return __default.UInt24ToIndexSeq(__default.SeqPosToUInt24(s, pos));
    }

    public static DafnySequence<? extends Byte> DecodeRecursively(DafnySequence<? extends Byte> s) {
        DafnySequence b = DafnySequence.empty(uint8._typeDescriptor());
        long _0_i = s.cardinalityInt();
        DafnySequence _1_result = DafnySequence.empty(uint8._typeDescriptor());
        while (_0_i != 0L) {
            _1_result = DafnySequence.concatenate(__default.DecodeBlockPos(s, _0_i - 4L), (DafnySequence)_1_result);
            _0_i -= 4L;
        }
        b = _1_result;
        return b;
    }

    public static DafnySequence<? extends Byte> EncodeRecursively(DafnySequence<? extends Byte> b) {
        DafnySequence s = DafnySequence.empty(index._typeDescriptor());
        long _0_i = b.cardinalityInt();
        DafnySequence _1_result = DafnySequence.empty(index._typeDescriptor());
        while (_0_i != 0L) {
            _1_result = DafnySequence.concatenate(__default.EncodeBlockPos(b, _0_i - 3L), (DafnySequence)_1_result);
            _0_i -= 3L;
        }
        s = _1_result;
        return s;
    }

    public static DafnySequence<? extends Byte> FromCharsToIndices(DafnySequence<? extends Character> s) {
        DafnySequence b = DafnySequence.empty(index._typeDescriptor());
        DafnySequence _0_result = DafnySequence.empty(index._typeDescriptor());
        long _hi0 = s.cardinalityInt();
        long _1_i = 0L;
        while (Long.compareUnsigned(_1_i, _hi0) < 0) {
            _0_result = DafnySequence.concatenate((DafnySequence)_0_result, (DafnySequence)DafnySequence.of((byte[])new byte[]{__default.CharToIndex(((Character)s.select(Helpers.unsignedToInt((long)_1_i))).charValue())}));
            ++_1_i;
        }
        b = _0_result;
        return b;
    }

    public static DafnySequence<? extends Character> FromIndicesToChars(DafnySequence<? extends Byte> b) {
        DafnySequence s = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        DafnySequence _0_result = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        long _hi0 = b.cardinalityInt();
        long _1_i = 0L;
        while (Long.compareUnsigned(_1_i, _hi0) < 0) {
            _0_result = DafnySequence.concatenate((DafnySequence)_0_result, (DafnySequence)DafnySequence.of((char[])new char[]{__default.IndexToChar((Byte)b.select(Helpers.unsignedToInt((long)_1_i)))}));
            ++_1_i;
        }
        s = _0_result;
        return s;
    }

    public static DafnySequence<? extends Byte> DecodeUnpadded(DafnySequence<? extends Character> s) {
        return __default.DecodeRecursively(__default.FromCharsToIndices(s));
    }

    public static DafnySequence<? extends Character> EncodeUnpadded(DafnySequence<? extends Byte> b) {
        return __default.FromIndicesToChars(__default.EncodeRecursively(b));
    }

    public static boolean Is1Padding(DafnySequence<? extends Character> s) {
        return (long)s.cardinalityInt() == 4L && __default.IsBase64Char(((Character)s.select(0)).charValue()) && __default.IsBase64Char(((Character)s.select(1)).charValue()) && __default.IsBase64Char(((Character)s.select(2)).charValue()) && !(Helpers.remainderUnsignedByte((byte)__default.CharToIndex(((Character)s.select(2)).charValue()), (byte)4) != 0) && ((Character)s.select(3)).charValue() == '=';
    }

    public static DafnySequence<? extends Byte> Decode1Padding(DafnySequence<? extends Character> s) {
        DafnySequence<? extends Byte> _0_d = __default.DecodeBlock((DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{__default.CharToIndex(((Character)s.select(0)).charValue()), __default.CharToIndex(((Character)s.select(1)).charValue()), __default.CharToIndex(((Character)s.select(2)).charValue()), 0}));
        return DafnySequence.of((byte[])new byte[]{(Byte)_0_d.select(0), (Byte)_0_d.select(1)});
    }

    public static DafnySequence<? extends Character> Encode1Padding(DafnySequence<? extends Byte> b) {
        DafnySequence<? extends Byte> _0_e = __default.EncodeBlock((DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{(Byte)b.select(0), (Byte)b.select(1), 0}));
        return DafnySequence.of((char[])new char[]{__default.IndexToChar((Byte)_0_e.select(0)), __default.IndexToChar((Byte)_0_e.select(1)), __default.IndexToChar((Byte)_0_e.select(2)), '='});
    }

    public static boolean Is2Padding(DafnySequence<? extends Character> s) {
        return (long)s.cardinalityInt() == 4L && __default.IsBase64Char(((Character)s.select(0)).charValue()) && __default.IsBase64Char(((Character)s.select(1)).charValue()) && !(Helpers.remainderUnsignedByte((byte)__default.CharToIndex(((Character)s.select(1)).charValue()), (byte)16) != 0) && ((Character)s.select(2)).charValue() == '=' && ((Character)s.select(3)).charValue() == '=';
    }

    public static DafnySequence<? extends Byte> Decode2Padding(DafnySequence<? extends Character> s) {
        DafnySequence<? extends Byte> _0_d = __default.DecodeBlock((DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{__default.CharToIndex(((Character)s.select(0)).charValue()), __default.CharToIndex(((Character)s.select(1)).charValue()), 0, 0}));
        return DafnySequence.of((byte[])new byte[]{(Byte)_0_d.select(0)});
    }

    public static DafnySequence<? extends Character> Encode2Padding(DafnySequence<? extends Byte> b) {
        DafnySequence<? extends Byte> _0_e = __default.EncodeBlock((DafnySequence<? extends Byte>)DafnySequence.of((byte[])new byte[]{(Byte)b.select(0), 0, 0}));
        return DafnySequence.of((char[])new char[]{__default.IndexToChar((Byte)_0_e.select(0)), __default.IndexToChar((Byte)_0_e.select(1)), '=', '='});
    }

    public static boolean IsBase64String(DafnySequence<? extends Character> s) {
        long _0_size = s.cardinalityInt();
        return !(Long.remainderUnsigned(_0_size, 4L) != 0L) && (__default.IsUnpaddedBase64String(s) || __default.IsUnpaddedBase64String((DafnySequence<? extends Character>)s.take(_0_size - 4L)) && (__default.Is1Padding((DafnySequence<? extends Character>)s.drop(_0_size - 4L)) || __default.Is2Padding((DafnySequence<? extends Character>)s.drop(_0_size - 4L))));
    }

    public static DafnySequence<? extends Byte> DecodeValid(DafnySequence<? extends Character> s) {
        long _0_size = s.cardinalityInt();
        if (!(_0_size != 0L)) {
            return DafnySequence.empty(uint8._typeDescriptor());
        }
        long _1_finalBlockStart = _0_size - 4L;
        DafnySequence _2_prefix = s.take(_1_finalBlockStart);
        DafnySequence _3_suffix = s.drop(_1_finalBlockStart);
        if (__default.Is1Padding((DafnySequence<? extends Character>)_3_suffix)) {
            return DafnySequence.concatenate(__default.DecodeUnpadded((DafnySequence<? extends Character>)_2_prefix), __default.Decode1Padding((DafnySequence<? extends Character>)_3_suffix));
        }
        if (__default.Is2Padding((DafnySequence<? extends Character>)_3_suffix)) {
            return DafnySequence.concatenate(__default.DecodeUnpadded((DafnySequence<? extends Character>)_2_prefix), __default.Decode2Padding((DafnySequence<? extends Character>)_3_suffix));
        }
        return __default.DecodeUnpadded(s);
    }

    public static Result<DafnySequence<? extends Byte>, DafnySequence<? extends Character>> Decode(DafnySequence<? extends Character> s) {
        if (__default.IsBase64String(s)) {
            return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), __default.DecodeValid(s));
        }
        return Result.create_Failure(DafnySequence._typeDescriptor(uint8._typeDescriptor()), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence.asString((String)"The encoding is malformed"));
    }

    public static DafnySequence<? extends Character> Encode(DafnySequence<? extends Byte> b) {
        long _0_size = b.cardinalityInt();
        long _1_mod = Long.remainderUnsigned(_0_size, 3L);
        if (!(_1_mod != 0L)) {
            DafnySequence<? extends Character> _2_s = __default.EncodeUnpadded(b);
            return _2_s;
        }
        if (_1_mod == 1L) {
            DafnySequence<? extends Character> _3_s1 = __default.EncodeUnpadded((DafnySequence<? extends Byte>)b.take(_0_size - 1L));
            DafnySequence<? extends Character> _4_s2 = __default.Encode2Padding((DafnySequence<? extends Byte>)b.drop(_0_size - 1L));
            DafnySequence _5_s = DafnySequence.concatenate(_3_s1, _4_s2);
            return _5_s;
        }
        DafnySequence<? extends Character> _6_s1 = __default.EncodeUnpadded((DafnySequence<? extends Byte>)b.take(_0_size - 2L));
        DafnySequence<? extends Character> _7_s2 = __default.Encode1Padding((DafnySequence<? extends Byte>)b.drop(_0_size - 2L));
        DafnySequence _8_s = DafnySequence.concatenate(_6_s1, _7_s2);
        return _8_s;
    }

    public String toString() {
        return "Base64._default";
    }
}

