/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.bulk.BulkItemRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionRequestMetadata;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.privileges.ActionPrivileges;
import org.opensearch.security.privileges.DocumentAllowList;
import org.opensearch.security.privileges.PitPrivilegesEvaluator;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.PrivilegesInterceptor;
import org.opensearch.security.privileges.ProtectedIndexAccessEvaluator;
import org.opensearch.security.privileges.RoleMapper;
import org.opensearch.security.privileges.SnapshotRestoreEvaluator;
import org.opensearch.security.privileges.SystemIndexAccessEvaluator;
import org.opensearch.security.privileges.TermsAggregationEvaluator;
import org.opensearch.security.privileges.actionlevel.RoleBasedActionPrivileges;
import org.opensearch.security.privileges.actionlevel.SubjectBasedActionPrivileges;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;

public class PrivilegesEvaluatorImpl
implements PrivilegesEvaluator {
    static final WildcardMatcher DNFOF_MATCHER = WildcardMatcher.from(ImmutableList.of((Object)"indices:data/read/*", (Object)"indices:admin/mappings/fields/get*", (Object)"indices:admin/shards/search_shards", (Object)"indices:admin/resolve/index", (Object)"indices:monitor/settings/get", (Object)"indices:monitor/stats", (Object)"indices:admin/aliases/get"));
    private static final WildcardMatcher ACTION_MATCHER = WildcardMatcher.from("indices:data/read/*search*");
    private static final IndicesOptions ALLOW_EMPTY = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false);
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final Supplier<ClusterState> clusterStateSupplier;
    private final IndexNameExpressionResolver resolver;
    private final AuditLog auditLog;
    private final ThreadContext threadContext;
    private final ThreadPool threadPool;
    private PrivilegesInterceptor privilegesInterceptor;
    private final boolean checkSnapshotRestoreWritePrivileges;
    private final IndexResolverReplacer irr;
    private final SnapshotRestoreEvaluator snapshotRestoreEvaluator;
    private final SystemIndexAccessEvaluator systemIndexAccessEvaluator;
    private final ProtectedIndexAccessEvaluator protectedIndexAccessEvaluator;
    private final TermsAggregationEvaluator termsAggregationEvaluator;
    private final PitPrivilegesEvaluator pitPrivilegesEvaluator;
    private final Settings settings;
    private final AtomicReference<RoleBasedActionPrivileges> actionPrivileges = new AtomicReference();
    private final ImmutableMap<String, ActionPrivileges> pluginIdToActionPrivileges;
    private final RoleMapper roleMapper;
    private volatile boolean dnfofEnabled = false;
    private volatile boolean dnfofForEmptyResultsEnabled = false;
    private volatile String filteredAliasMode = null;

    public PrivilegesEvaluatorImpl(ClusterService clusterService, Supplier<ClusterState> clusterStateSupplier, RoleMapper roleMapper, ThreadPool threadPool, ThreadContext threadContext, IndexNameExpressionResolver resolver, AuditLog auditLog, Settings settings, PrivilegesInterceptor privilegesInterceptor, IndexResolverReplacer irr, FlattenedActionGroups actionGroups, FlattenedActionGroups staticActionGroups, SecurityDynamicConfiguration<RoleV7> rolesConfiguration, ConfigV7 generalConfiguration, Map<String, RoleV7> pluginIdToRolePrivileges) {
        this.resolver = resolver;
        this.auditLog = auditLog;
        this.roleMapper = roleMapper;
        this.threadContext = threadContext;
        this.threadPool = threadPool;
        this.privilegesInterceptor = privilegesInterceptor;
        this.clusterStateSupplier = clusterStateSupplier;
        this.settings = settings;
        this.checkSnapshotRestoreWritePrivileges = settings.getAsBoolean("plugins.security.check_snapshot_restore_write_privileges", Boolean.valueOf(true));
        Supplier<Boolean> isLocalNodeElectedClusterManager = clusterService != null ? () -> clusterService.state().nodes().isLocalNodeElectedClusterManager() : () -> false;
        this.irr = irr;
        this.snapshotRestoreEvaluator = new SnapshotRestoreEvaluator(settings, auditLog, isLocalNodeElectedClusterManager);
        this.systemIndexAccessEvaluator = new SystemIndexAccessEvaluator(settings, auditLog, irr);
        this.protectedIndexAccessEvaluator = new ProtectedIndexAccessEvaluator(settings, auditLog);
        this.termsAggregationEvaluator = new TermsAggregationEvaluator();
        this.pitPrivilegesEvaluator = new PitPrivilegesEvaluator();
        this.pluginIdToActionPrivileges = PrivilegesEvaluatorImpl.createActionPrivileges(pluginIdToRolePrivileges, staticActionGroups);
        this.updateConfiguration(actionGroups, rolesConfiguration, generalConfiguration);
    }

    @Override
    public PrivilegesEvaluator.PrivilegesEvaluatorType type() {
        return PrivilegesEvaluator.PrivilegesEvaluatorType.STANDARD;
    }

    @Override
    public void updateConfiguration(FlattenedActionGroups flattenedActionGroups, SecurityDynamicConfiguration<RoleV7> rolesConfiguration, ConfigV7 generalConfiguration) {
        this.dnfofEnabled = PrivilegesEvaluatorImpl.isDnfofEnabled(generalConfiguration);
        this.dnfofForEmptyResultsEnabled = PrivilegesEvaluatorImpl.isDnfofEmptyEnabled(generalConfiguration);
        this.filteredAliasMode = PrivilegesEvaluatorImpl.getFilteredAliasMode(generalConfiguration);
        try {
            RoleBasedActionPrivileges actionPrivileges = new RoleBasedActionPrivileges(rolesConfiguration, flattenedActionGroups, this.settings);
            Metadata metadata = this.clusterStateSupplier.get().metadata();
            actionPrivileges.updateStatefulIndexPrivileges(metadata.getIndicesLookup(), metadata.version());
            RoleBasedActionPrivileges oldInstance = this.actionPrivileges.getAndSet(actionPrivileges);
            if (oldInstance != null) {
                oldInstance.clusterStateMetadataDependentPrivileges().shutdown();
            }
        }
        catch (Exception e) {
            this.log.error("Error while updating ActionPrivileges", (Throwable)e);
        }
    }

    @Override
    public void updateClusterStateMetadata(ClusterService clusterService) {
        RoleBasedActionPrivileges actionPrivileges = this.actionPrivileges.get();
        if (actionPrivileges != null) {
            actionPrivileges.clusterStateMetadataDependentPrivileges().updateClusterStateMetadataAsync(clusterService, this.threadPool);
        }
    }

    @Override
    public void shutdown() {
        RoleBasedActionPrivileges roleBasedActionPrivileges = this.actionPrivileges.get();
        if (roleBasedActionPrivileges != null) {
            roleBasedActionPrivileges.clusterStateMetadataDependentPrivileges().shutdown();
        }
    }

    @Override
    public PrivilegesEvaluationContext createContext(User user, String action) {
        return this.createContext(user, action, null, null, null);
    }

    @Override
    public PrivilegesEvaluationContext createContext(User user, String action0, ActionRequest request, ActionRequestMetadata<?, ?> actionRequestMetadata, Task task) {
        ActionPrivileges actionPrivileges;
        ImmutableSet<String> mappedRoles;
        TransportAddress caller = (TransportAddress)this.threadContext.getTransient("_opendistro_security_remote_address");
        if (user.isPluginUser()) {
            mappedRoles = ImmutableSet.of();
            actionPrivileges = (ActionPrivileges)this.pluginIdToActionPrivileges.getOrDefault((Object)user.getName(), (Object)ActionPrivileges.EMPTY);
        } else {
            mappedRoles = this.roleMapper.map(user, caller);
            actionPrivileges = this.actionPrivileges.get();
        }
        return new PrivilegesEvaluationContext(user, mappedRoles, action0, request, task, this.irr, this.resolver, this.clusterStateSupplier, actionPrivileges);
    }

    @Override
    public PrivilegesEvaluatorResponse evaluate(PrivilegesEvaluationContext context) {
        boolean isDebugEnabled;
        String action0 = context.getAction();
        ImmutableSet<String> mappedRoles = context.getMappedRoles();
        User user = context.getUser();
        ActionRequest request = context.getRequest();
        Task task = context.getTask();
        if (action0.startsWith("internal:indices/admin/upgrade")) {
            action0 = "indices:admin/upgrade";
        }
        if ("indices:admin/auto_create".equals(action0)) {
            action0 = "indices:admin/create";
        }
        if ("indices:admin/mapping/auto_put".equals(action0)) {
            action0 = "indices:admin/mapping/put";
        }
        if (isDebugEnabled = this.log.isDebugEnabled()) {
            this.log.debug("Evaluate permissions for {}", (Object)user);
            this.log.debug("Action: {} ({})", (Object)action0, (Object)request.getClass().getSimpleName());
            this.log.debug("Mapped roles: {}", (Object)mappedRoles.toString());
        }
        ActionPrivileges actionPrivileges = context.getActionPrivileges();
        if (request instanceof BulkRequest && Strings.isNullOrEmpty((String)user.getRequestedTenant())) {
            PrivilegesEvaluatorResponse presponse = actionPrivileges.hasClusterPrivilege(context, action0);
            if (!presponse.isAllowed()) {
                this.log.info("No cluster-level perm match for {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)action0, mappedRoles, presponse.getMissingPrivileges());
            }
            return presponse;
        }
        IndexResolverReplacer.Resolved requestedResolved = context.getResolvedRequest();
        this.log.debug("RequestedResolved : {}", (Object)requestedResolved);
        PrivilegesEvaluatorResponse presponse = this.snapshotRestoreEvaluator.evaluate(request, task, action0);
        if (presponse != null) {
            return presponse;
        }
        presponse = this.systemIndexAccessEvaluator.evaluate(request, task, action0, requestedResolved, context, actionPrivileges, user);
        if (presponse != null) {
            return presponse;
        }
        presponse = this.protectedIndexAccessEvaluator.evaluate(request, task, action0, requestedResolved, (Set<String>)mappedRoles);
        if (presponse != null) {
            return presponse;
        }
        presponse = this.pitPrivilegesEvaluator.evaluate(request, context, actionPrivileges, action0, this.irr);
        if (presponse != null) {
            return presponse;
        }
        boolean dnfofEnabled = this.dnfofEnabled;
        this.log.trace("dnfof enabled? {}", (Object)dnfofEnabled);
        boolean serviceAccountUser = user.isServiceAccount();
        if (PrivilegesEvaluatorImpl.isClusterPerm(action0)) {
            if (serviceAccountUser) {
                this.log.info("{} is a service account which doesn't have access to cluster level permission: {}", (Object)user, (Object)action0);
                return PrivilegesEvaluatorResponse.insufficient(action0);
            }
            presponse = actionPrivileges.hasClusterPrivilege(context, action0);
            if (!presponse.isAllowed()) {
                this.log.info("No cluster-level perm match for {} {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)requestedResolved, (Object)action0, mappedRoles, presponse.getMissingPrivileges());
                return presponse;
            }
            if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
                this.log.debug("Normally allowed but we need to apply some extra checks for a restore request.");
            } else {
                if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
                    PrivilegesInterceptor.ReplaceResult replaceResult = this.privilegesInterceptor.replaceDashboardsIndex(request, action0, user, requestedResolved, context);
                    this.log.debug("Result from privileges interceptor for cluster perm: {}", (Object)replaceResult);
                    if (!replaceResult.continueEvaluation) {
                        if (replaceResult.accessDenied) {
                            this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                        } else {
                            return PrivilegesEvaluatorResponse.ok().with(replaceResult.createIndexRequestBuilder);
                        }
                    }
                }
                this.log.debug("Allowed because we have cluster permissions for {}", (Object)action0);
                return PrivilegesEvaluatorResponse.ok();
            }
        }
        if (this.checkDocAllowListHeader(user, action0, request)) {
            return PrivilegesEvaluatorResponse.ok();
        }
        presponse = this.termsAggregationEvaluator.evaluate(requestedResolved, request, context, actionPrivileges);
        if (presponse != null) {
            return presponse;
        }
        ImmutableSet<String> allIndexPermsRequired = this.evaluateAdditionalIndexPermissions(request, action0);
        this.log.debug("Requested {}", allIndexPermsRequired);
        this.log.debug("Requested resolved index types: {}", (Object)requestedResolved);
        this.log.debug("Security roles: {}", mappedRoles);
        if (this.privilegesInterceptor.getClass() != PrivilegesInterceptor.class) {
            PrivilegesInterceptor.ReplaceResult replaceResult = this.privilegesInterceptor.replaceDashboardsIndex(request, action0, user, requestedResolved, context);
            this.log.debug("Result from privileges interceptor: {}", (Object)replaceResult);
            if (!replaceResult.continueEvaluation) {
                if (replaceResult.accessDenied) {
                    this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                    return PrivilegesEvaluatorResponse.insufficient(action0);
                }
                return PrivilegesEvaluatorResponse.ok().with(replaceResult.createIndexRequestBuilder);
            }
        }
        boolean dnfofPossible = dnfofEnabled && DNFOF_MATCHER.test(action0);
        presponse = actionPrivileges.hasIndexPrivilege(context, (Set<String>)allIndexPermsRequired, requestedResolved);
        if (presponse.isPartiallyOk()) {
            if (dnfofPossible && this.irr.replace((TransportRequest)request, true, presponse.getAvailableIndices())) {
                return PrivilegesEvaluatorResponse.ok();
            }
        } else if (!presponse.isAllowed() && dnfofPossible && this.dnfofForEmptyResultsEnabled && request instanceof IndicesRequest.Replaceable) {
            ((IndicesRequest.Replaceable)request).indices(new String[0]);
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).indicesOptions(ALLOW_EMPTY);
            } else if (request instanceof ClusterSearchShardsRequest) {
                ((ClusterSearchShardsRequest)request).indicesOptions(ALLOW_EMPTY);
            } else if (request instanceof GetFieldMappingsRequest) {
                ((GetFieldMappingsRequest)request).indicesOptions(ALLOW_EMPTY);
            }
            return PrivilegesEvaluatorResponse.ok();
        }
        if (presponse.isAllowed()) {
            if (this.checkFilteredAliases(requestedResolved, action0, isDebugEnabled)) {
                return PrivilegesEvaluatorResponse.insufficient(action0);
            }
            this.log.debug("Allowed because we have all indices permissions for {}", (Object)action0);
        } else {
            this.log.info("No {}-level perm match for {} {}: {} [Action [{}]] [RolesChecked {}]", (Object)"index", (Object)user, (Object)requestedResolved, (Object)presponse.getReason(), (Object)action0, mappedRoles);
            this.log.info("Index to privilege matrix:\n{}", (Object)presponse.getPrivilegeMatrix());
            if (presponse.hasEvaluationExceptions()) {
                this.log.info("Evaluation errors:\n{}", (Object)presponse.getEvaluationExceptionInfo());
            }
        }
        return presponse;
    }

    @Override
    public boolean notFailOnForbiddenEnabled() {
        return this.dnfofEnabled;
    }

    private ImmutableSet<String> evaluateAdditionalIndexPermissions(ActionRequest request, String originalAction) {
        ImmutableSet result;
        CreateIndexRequest cir;
        BulkShardRequest bsr;
        ImmutableSet.Builder additionalPermissionsRequired = ImmutableSet.builder();
        if (!PrivilegesEvaluatorImpl.isClusterPerm(originalAction)) {
            additionalPermissionsRequired.add((Object)originalAction);
        }
        if (request instanceof ClusterSearchShardsRequest) {
            additionalPermissionsRequired.add((Object)"indices:data/read/search");
        }
        if (request instanceof BulkShardRequest) {
            bsr = (BulkShardRequest)request;
            block9: for (BulkItemRequest bir : bsr.items()) {
                switch (bir.request().opType()) {
                    case CREATE: {
                        additionalPermissionsRequired.add((Object)"indices:data/write/index");
                        continue block9;
                    }
                    case INDEX: {
                        additionalPermissionsRequired.add((Object)"indices:data/write/index");
                        continue block9;
                    }
                    case DELETE: {
                        additionalPermissionsRequired.add((Object)"indices:data/write/delete");
                        continue block9;
                    }
                    case UPDATE: {
                        additionalPermissionsRequired.add((Object)"indices:data/write/update");
                    }
                }
            }
        }
        if (request instanceof IndicesAliasesRequest) {
            bsr = (IndicesAliasesRequest)request;
            for (IndicesAliasesRequest.AliasActions bir : bsr.getAliasActions()) {
                switch (bir.actionType()) {
                    case REMOVE_INDEX: {
                        additionalPermissionsRequired.add((Object)"indices:admin/delete");
                        break;
                    }
                }
            }
        }
        if (request instanceof CreateIndexRequest && (cir = (CreateIndexRequest)request).aliases() != null && !cir.aliases().isEmpty()) {
            additionalPermissionsRequired.add((Object)"indices:admin/aliases");
        }
        if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
            additionalPermissionsRequired.addAll(ConfigConstants.SECURITY_SNAPSHOT_RESTORE_NEEDED_WRITE_PRIVILEGES);
        }
        if ((result = additionalPermissionsRequired.build()).size() > 1) {
            OpenSearchSecurityPlugin.traceAction("Additional permissions required: {}", result);
            this.log.debug("Additional permissions required: {}", (Object)result);
        }
        return result;
    }

    @Override
    public boolean isClusterPermission(String action) {
        return PrivilegesEvaluatorImpl.isClusterPerm(action);
    }

    public static boolean isClusterPerm(String action0) {
        return action0.startsWith("cluster:") || action0.startsWith("indices:admin/template/") || action0.startsWith("indices:admin/index_template/") || action0.startsWith("indices:data/read/scroll") || action0.equals("indices:data/write/bulk") || action0.equals("indices:data/read/mget") || action0.startsWith("indices:data/read/msearch") || action0.equals("indices:data/read/mtv") || action0.equals("indices:data/write/reindex") || action0.equals("indices:data/read/search/template/render");
    }

    private boolean checkFilteredAliases(IndexResolverReplacer.Resolved requestedResolved, String action, boolean isDebugEnabled) {
        Iterable<IndexMetadata> indexMetaDataCollection;
        String faMode = this.filteredAliasMode;
        if (!"disallow".equals(faMode)) {
            return false;
        }
        if (!ACTION_MATCHER.test(action)) {
            return false;
        }
        if (requestedResolved.isLocalAll()) {
            indexMetaDataCollection = new Iterable<IndexMetadata>(){

                @Override
                public Iterator<IndexMetadata> iterator() {
                    return PrivilegesEvaluatorImpl.this.clusterStateSupplier.get().getMetadata().getIndices().values().iterator();
                }
            };
        } else {
            HashSet<IndexMetadata> indexMetaDataSet = new HashSet<IndexMetadata>(requestedResolved.getAllIndices().size());
            for (String requestAliasOrIndex : requestedResolved.getAllIndices()) {
                IndexMetadata indexMetaData = (IndexMetadata)this.clusterStateSupplier.get().getMetadata().getIndices().get(requestAliasOrIndex);
                if (indexMetaData == null) {
                    this.log.debug("{} does not exist in cluster metadata", (Object)requestAliasOrIndex);
                    continue;
                }
                indexMetaDataSet.add(indexMetaData);
            }
            indexMetaDataCollection = indexMetaDataSet;
        }
        for (IndexMetadata indexMetaData : indexMetaDataCollection) {
            ArrayList<AliasMetadata> filteredAliases = new ArrayList<AliasMetadata>();
            Map aliases = indexMetaData.getAliases();
            if (aliases != null && aliases.size() > 0) {
                this.log.debug("Aliases for {}: {}", (Object)indexMetaData.getIndex().getName(), (Object)aliases);
                for (String alias : aliases.keySet()) {
                    AliasMetadata aliasMetadata = (AliasMetadata)aliases.get(alias);
                    if (aliasMetadata != null && aliasMetadata.filteringRequired()) {
                        filteredAliases.add(aliasMetadata);
                        this.log.debug("{} is a filtered alias {}", (Object)alias, (Object)aliasMetadata.getFilter());
                        continue;
                    }
                    this.log.debug("{} is not an alias or does not have a filter", (Object)alias);
                }
            }
            if (filteredAliases.size() <= 1 || !ACTION_MATCHER.test(action)) continue;
            this.log.error("More than one ({}) filtered alias found for same index ({}). This is currently not supported. Aliases: {}", (Object)filteredAliases.size(), (Object)indexMetaData.getIndex().getName(), this.toString(filteredAliases));
            return true;
        }
        return false;
    }

    private boolean checkDocAllowListHeader(User user, String action, ActionRequest request) {
        String docAllowListHeader = this.threadContext.getHeader("_opendistro_security_doc_allowlist");
        if (docAllowListHeader == null) {
            return false;
        }
        if (!(request instanceof GetRequest)) {
            return false;
        }
        try {
            DocumentAllowList documentAllowList = DocumentAllowList.parse(docAllowListHeader);
            GetRequest getRequest = (GetRequest)request;
            if (documentAllowList.isAllowed(getRequest.index(), getRequest.id())) {
                this.log.debug("Request {} is allowed by {}", (Object)request, (Object)documentAllowList);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.error("Error while handling document allow list: {}", (Object)docAllowListHeader, (Object)e);
            return false;
        }
    }

    private List<String> toString(List<AliasMetadata> aliases) {
        if (aliases == null || aliases.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(aliases.size());
        for (AliasMetadata amd : aliases) {
            if (amd == null) continue;
            ret.add(amd.alias());
        }
        return Collections.unmodifiableList(ret);
    }

    private static ImmutableMap<String, ActionPrivileges> createActionPrivileges(Map<String, RoleV7> pluginIdToRolePrivileges, FlattenedActionGroups staticActionGroups) {
        HashMap<String, SubjectBasedActionPrivileges> result = new HashMap<String, SubjectBasedActionPrivileges>(pluginIdToRolePrivileges.size());
        for (Map.Entry<String, RoleV7> entry : pluginIdToRolePrivileges.entrySet()) {
            result.put(entry.getKey(), new SubjectBasedActionPrivileges(entry.getValue(), staticActionGroups));
        }
        return ImmutableMap.copyOf(result);
    }

    private static boolean isDnfofEnabled(ConfigV7 generalConfiguration) {
        return generalConfiguration.dynamic != null && generalConfiguration.dynamic.do_not_fail_on_forbidden;
    }

    private static boolean isDnfofEmptyEnabled(ConfigV7 generalConfiguration) {
        return generalConfiguration.dynamic != null && generalConfiguration.dynamic.do_not_fail_on_forbidden_empty;
    }

    private static String getFilteredAliasMode(ConfigV7 generalConfiguration) {
        return generalConfiguration.dynamic != null ? generalConfiguration.dynamic.filtered_alias_mode : "none";
    }
}

