import * as lst from "vscode-languageserver-types";
import { Color as Color$1, ColorInformation, ColorPresentation } from "vscode-languageserver-types";
import { TextDocument } from "vscode-languageserver-textdocument";

//#region src/types.d.ts
declare const errorSource: {
  readonly Scan: 1;
  readonly Parse: 2;
  readonly Check: 4;
};
type ErrorSource = (typeof errorSource)[keyof typeof errorSource];
type ErrorCode = ParseErrorCode | ScanErrorCode | CheckErrorCode;
interface ParseErrorCode {
  source: typeof errorSource.Parse;
  sub: ParseError;
}
interface ScanErrorCode {
  source: typeof errorSource.Scan;
  sub: ScanError;
}
interface CheckErrorCode {
  source: typeof errorSource.Check;
  sub: CheckError;
}
declare const parseError: {
  readonly ExpectationFailed: 0;
  readonly TrailingData: 1;
  readonly FailedListParsing: 2;
};
type ParseError = (typeof parseError)[keyof typeof parseError];
declare const scanError: {
  readonly ExpectationFailed: 0;
  readonly Unterminated: 1;
};
type ScanError = (typeof scanError)[keyof typeof scanError];
declare const checkError: {
  readonly InvalidEdgeOperation: 0;
  readonly InvalidShapeName: 1;
};
type CheckError = (typeof checkError)[keyof typeof checkError];
interface DiagnosticMessage {
  message: string;
  code: ErrorCode;
  category: DiagnosticCategory;
  start: number;
  end: number;
}
declare const diagnosticCategory: {
  readonly Error: 1;
  readonly Warning: 2;
  readonly Message: 3;
  readonly Suggestion: 4;
};
type DiagnosticCategory = (typeof diagnosticCategory)[keyof typeof diagnosticCategory];
type ID = string;
interface SourceFile {
  content: string;
  graph?: Graph;
  identifiers: Set<ID>;
  diagnostics: DiagnosticMessage[];
  symbols?: SymbolTable;
  colors?: ColorTable;
}
interface HtmlIdentifier extends SyntaxNode {
  kind: typeof syntaxKind.HtmlIdentifier;
  htmlContent: string;
}
interface TextIdentifier extends SyntaxNode {
  kind: typeof syntaxKind.TextIdentifier;
  text: string;
}
interface QuotedTextIdentifier extends SyntaxNode {
  kind: typeof syntaxKind.QuotedTextIdentifier;
  values: SyntaxNodeArray<StringLiteral>;
  concatenation?: string;
}
interface StringLiteral extends SyntaxNode {
  kind: typeof syntaxKind.StringLiteral;
  text: string;
}
interface NumericIdentifier extends SyntaxNode {
  kind: typeof syntaxKind.NumericIdentifier;
  text: string;
  value: number;
}
type Identifier = TextIdentifier | QuotedTextIdentifier | HtmlIdentifier | NumericIdentifier;
interface Graph extends SyntaxNode {
  kind: typeof syntaxKind.DirectedGraph | typeof syntaxKind.UndirectedGraph;
  keyword: Token<typeof syntaxKind.GraphKeyword | typeof syntaxKind.DigraphKeyword>;
  strict?: Token<typeof syntaxKind.StrictKeyword>;
  id?: Identifier;
  statements: SyntaxNodeArray<Statement>;
}
interface StatementBase {
  terminator?: StatementSeparator;
}
type StatementSeparator = Token<typeof syntaxKind.SemicolonToken>;
type Statement = NodeStatement | EdgeStatement | AttributeStatement | IdEqualsIdStatement | SubGraphStatement;
interface NodeStatement extends SyntaxNode, StatementBase {
  kind: typeof syntaxKind.NodeStatement;
  id: NodeId;
  attributes: SyntaxNodeArray<AttributeContainer>;
}
interface NodeId extends SyntaxNode {
  kind: typeof syntaxKind.NodeId;
  id: Identifier;
  port?: PortDeclaration;
}
type EdgeSourceOrTarget = NodeId | SubGraph;
interface EdgeStatement extends SyntaxNode, StatementBase {
  kind: typeof syntaxKind.EdgeStatement;
  source: EdgeSourceOrTarget;
  rhs: SyntaxNodeArray<EdgeRhs>;
  attributes: SyntaxNodeArray<AttributeContainer>;
}
interface AttributeStatement extends SyntaxNode, StatementBase {
  kind: typeof syntaxKind.AttributeStatement;
  subject: Token<typeof syntaxKind.GraphKeyword> | Token<typeof syntaxKind.NodeKeyword> | Token<typeof syntaxKind.EdgeKeyword>;
  attributes: SyntaxNodeArray<AttributeContainer>;
}
interface IdEqualsIdStatement extends SyntaxNode, StatementBase {
  kind: typeof syntaxKind.IdEqualsIdStatement;
  leftId: Identifier;
  rightId: Identifier;
}
interface SubGraph extends SyntaxNode {
  kind: typeof syntaxKind.SubGraph;
  id?: Identifier;
  statements: SyntaxNodeArray<Statement>;
}
interface SubGraphStatement extends SyntaxNode, StatementBase {
  kind: typeof syntaxKind.SubGraphStatement;
  subgraph: SubGraph;
}
interface EdgeRhs extends SyntaxNode {
  kind: typeof syntaxKind.EdgeRhs;
  operation: EdgeOp;
  target: EdgeSourceOrTarget;
}
interface AttributeContainer extends SyntaxNode {
  kind: typeof syntaxKind.AttributeContainer;
  openBracket: Token<typeof syntaxKind.OpenBracketToken>;
  assignments: SyntaxNodeArray<Assignment>;
  closeBracket: Token<typeof syntaxKind.CloseBracketToken>;
}
interface Assignment extends SyntaxNode {
  kind: typeof syntaxKind.Assignment;
  leftId: Identifier;
  rightId: Identifier;
  terminator?: AssignmentSeparator;
}
type AssignmentSeparator = Token<typeof syntaxKind.SemicolonToken> | Token<typeof syntaxKind.CommaToken>;
type PortDeclaration = NormalPortDeclaration | CompassPortDeclaration;
interface NormalPortDeclaration extends SyntaxNode {
  kind: typeof syntaxKind.NormalPortDeclaration;
  colon: Token<typeof syntaxKind.ColonToken>;
  id: Identifier;
  compassPt?: CompassPortDeclaration;
}
interface CompassPortDeclaration extends SyntaxNode {
  kind: typeof syntaxKind.CompassPortDeclaration;
  colon: Token<typeof syntaxKind.ColonToken>;
  compassPt: CompassPort;
}
type CompassPort = Token<typeof syntaxKind.CompassNorthToken> | Token<typeof syntaxKind.CompassNorthEastToken> | Token<typeof syntaxKind.CompassEastToken> | Token<typeof syntaxKind.CompassSouthEastToken> | Token<typeof syntaxKind.CompassSouthToken> | Token<typeof syntaxKind.CompassSouthWestToken> | Token<typeof syntaxKind.CompassWestToken> | Token<typeof syntaxKind.CompassNorthWestToken> | Token<typeof syntaxKind.CompassCenterToken> | Token<typeof syntaxKind.UnderscoreToken>;
type EdgeOp = Token<typeof syntaxKind.DirectedEdgeOp> | Token<typeof syntaxKind.UndirectedEdgeOp>;
interface TextRange {
  pos: number;
  end: number;
}
type SyntaxKind = (typeof syntaxKind)[keyof typeof syntaxKind];
declare const syntaxKind: {
  readonly Unknown: 0;
  readonly EndOfFileToken: 1;
  readonly NewLineTrivia: 2;
  readonly WhitespaceTrivia: 3;
  readonly HashCommentTrivia: 4;
  readonly SingleLineCommentTrivia: 5;
  readonly MultiLineCommentTrivia: 6;
  readonly CommaToken: 7;
  readonly SemicolonToken: 8;
  readonly PlusToken: 9;
  readonly OpenBraceToken: 10;
  readonly CloseBraceToken: 11;
  readonly OpenBracketToken: 12;
  readonly CloseBracketToken: 13;
  readonly ColonToken: 14;
  readonly EqualsToken: 15;
  readonly LessThan: 16;
  readonly GreaterThan: 17;
  readonly CompassNorthToken: 18;
  readonly CompassNorthEastToken: 19;
  readonly CompassEastToken: 20;
  readonly CompassSouthEastToken: 21;
  readonly CompassSouthToken: 22;
  readonly CompassSouthWestToken: 23;
  readonly CompassWestToken: 24;
  readonly CompassNorthWestToken: 25;
  readonly CompassCenterToken: 26;
  readonly UnderscoreToken: 27;
  readonly StringLiteral: 28;
  readonly HtmlIdentifier: 29;
  readonly TextIdentifier: 30;
  readonly QuotedTextIdentifier: 31;
  readonly NumericIdentifier: 32;
  readonly GraphKeyword: 33;
  readonly DigraphKeyword: 34;
  readonly NodeKeyword: 35;
  readonly EdgeKeyword: 36;
  readonly SubgraphKeyword: 37;
  readonly StrictKeyword: 38;
  readonly DirectedEdgeOp: 39;
  readonly UndirectedEdgeOp: 40;
  readonly DirectedGraph: 41;
  readonly UndirectedGraph: 42;
  readonly NodeStatement: 43;
  readonly EdgeStatement: 44;
  readonly AttributeStatement: 45;
  readonly IdEqualsIdStatement: 46;
  readonly SubGraph: 47;
  readonly SubGraphStatement: 48;
  readonly EdgeRhs: 49;
  readonly AttributeContainer: 50;
  readonly Assignment: 51;
  readonly NormalPortDeclaration: 52;
  readonly CompassPortDeclaration: 53;
  readonly NodeId: 54;
  readonly Count: 55;
  readonly FirstNode: 41;
  readonly CompassBegin: 18;
  readonly CompassEnd: 27;
  readonly LastKeyword: 38;
};
declare const syntaxKindNames: {
  readonly 0: "Unknown";
  readonly 1: "EndOfFileToken";
  readonly 2: "NewLineTrivia";
  readonly 3: "WhitespaceTrivia";
  readonly 4: "HashCommentTrivia";
  readonly 5: "SingleLineCommentTrivia";
  readonly 6: "MultiLineCommentTrivia";
  readonly 7: "CommaToken";
  readonly 8: "SemicolonToken";
  readonly 9: "PlusToken";
  readonly 10: "OpenBraceToken";
  readonly 11: "CloseBraceToken";
  readonly 12: "OpenBracketToken";
  readonly 13: "CloseBracketToken";
  readonly 14: "ColonToken";
  readonly 15: "EqualsToken";
  readonly 16: "LessThan";
  readonly 17: "GreaterThan";
  readonly 18: "CompassNorthToken";
  readonly 19: "CompassNorthEastToken";
  readonly 20: "CompassEastToken";
  readonly 21: "CompassSouthEastToken";
  readonly 22: "CompassSouthToken";
  readonly 23: "CompassSouthWestToken";
  readonly 24: "CompassWestToken";
  readonly 25: "CompassNorthWestToken";
  readonly 26: "CompassCenterToken";
  readonly 27: "UnderscoreToken";
  readonly 28: "StringLiteral";
  readonly 29: "HtmlIdentifier";
  readonly 30: "TextIdentifier";
  readonly 31: "QuotedTextIdentifier";
  readonly 32: "NumericIdentifier";
  readonly 33: "GraphKeyword";
  readonly 34: "DigraphKeyword";
  readonly 35: "NodeKeyword";
  readonly 36: "EdgeKeyword";
  readonly 37: "SubgraphKeyword";
  readonly 38: "StrictKeyword";
  readonly 39: "DirectedEdgeOp";
  readonly 40: "UndirectedEdgeOp";
  readonly 41: "DirectedGraph";
  readonly 42: "UndirectedGraph";
  readonly 43: "NodeStatement";
  readonly 44: "EdgeStatement";
  readonly 45: "AttributeStatement";
  readonly 46: "IdEqualsIdStatement";
  readonly 47: "SubGraph";
  readonly 48: "SubGraphStatement";
  readonly 49: "EdgeRhs";
  readonly 50: "AttributeContainer";
  readonly 51: "Assignment";
  readonly 52: "NormalPortDeclaration";
  readonly 53: "CompassPortDeclaration";
  readonly 54: "NodeId";
  readonly 55: "Count";
};
interface SyntaxNode extends TextRange {
  kind: SyntaxKind;
  flags: SyntaxNodeFlags;
  graphContext?: GraphContext;
  parent?: SyntaxNode;
  symbol?: TypeSymbol;
}
interface Token<TKind extends SyntaxKind> extends SyntaxNode {
  kind: TKind;
}
interface SyntaxNodeArray<T extends SyntaxNode> extends ReadonlyArray<T>, TextRange {
  hasTrailingComma?: boolean;
}
type MutableSyntaxNodeArray<T extends SyntaxNode> = SyntaxNodeArray<T> & T[];
declare const syntaxNodeFlags: {
  readonly None: 0;
  readonly ContainsErrors: number;
  readonly Synthesized: number;
};
type SyntaxNodeFlags = (typeof syntaxNodeFlags)[keyof typeof syntaxNodeFlags];
declare const graphContext: {
  readonly None: 0;
  readonly Strict: number;
  readonly Directed: number;
  readonly Undirected: number;
};
type GraphContext = (typeof graphContext)[keyof typeof graphContext];
declare const tokenFlags: {
  readonly None: 0;
  readonly Unterminated: number;
  readonly PrecedingLineBreak: number;
};
type TokenFlags = (typeof tokenFlags)[keyof typeof tokenFlags];
type CharacterCodes = (typeof characterCodes)[keyof typeof characterCodes];
declare const characterCodes: {
  readonly nullCharacter: 0;
  readonly maxAsciiCharacter: 127;
  readonly lineFeed: 10;
  readonly carriageReturn: 13;
  readonly lineSeparator: 8232;
  readonly paragraphSeparator: 8233;
  readonly nextLine: 133;
  readonly space: 32;
  readonly nonBreakingSpace: 160;
  readonly enQuad: 8192;
  readonly emQuad: 8193;
  readonly enSpace: 8194;
  readonly emSpace: 8195;
  readonly threePerEmSpace: 8196;
  readonly fourPerEmSpace: 8197;
  readonly sixPerEmSpace: 8198;
  readonly figureSpace: 8199;
  readonly punctuationSpace: 8200;
  readonly thinSpace: 8201;
  readonly hairSpace: 8202;
  readonly zeroWidthSpace: 8203;
  readonly narrowNoBreakSpace: 8239;
  readonly ideographicSpace: 12288;
  readonly mathematicalSpace: 8287;
  readonly ogham: 5760;
  readonly _: 95;
  readonly $: 36;
  readonly _0: 48;
  readonly _1: 49;
  readonly _2: 50;
  readonly _3: 51;
  readonly _4: 52;
  readonly _5: 53;
  readonly _6: 54;
  readonly _7: 55;
  readonly _8: 56;
  readonly _9: 57;
  readonly a: 97;
  readonly b: 98;
  readonly c: 99;
  readonly d: 100;
  readonly e: 101;
  readonly f: 102;
  readonly g: 103;
  readonly h: 104;
  readonly i: 105;
  readonly j: 106;
  readonly k: 107;
  readonly l: 108;
  readonly m: 109;
  readonly n: 110;
  readonly o: 111;
  readonly p: 112;
  readonly q: 113;
  readonly r: 114;
  readonly s: 115;
  readonly t: 116;
  readonly u: 117;
  readonly v: 118;
  readonly w: 119;
  readonly x: 120;
  readonly y: 121;
  readonly z: 122;
  readonly A: 65;
  readonly B: 66;
  readonly C: 67;
  readonly D: 68;
  readonly E: 69;
  readonly F: 70;
  readonly G: 71;
  readonly H: 72;
  readonly I: 73;
  readonly J: 74;
  readonly K: 75;
  readonly L: 76;
  readonly M: 77;
  readonly N: 78;
  readonly O: 79;
  readonly P: 80;
  readonly Q: 81;
  readonly R: 82;
  readonly S: 83;
  readonly T: 84;
  readonly U: 85;
  readonly V: 86;
  readonly W: 87;
  readonly X: 88;
  readonly Y: 89;
  readonly Z: 90;
  readonly ampersand: 38;
  readonly asterisk: 42;
  readonly at: 64;
  readonly backslash: 92;
  readonly backtick: 96;
  readonly bar: 124;
  readonly caret: 94;
  readonly closeBrace: 125;
  readonly closeBracket: 93;
  readonly closeParen: 41;
  readonly colon: 58;
  readonly comma: 44;
  readonly dot: 46;
  readonly doubleQuote: 34;
  readonly equals: 61;
  readonly exclamation: 33;
  readonly greaterThan: 62;
  readonly hash: 35;
  readonly lessThan: 60;
  readonly minus: 45;
  readonly openBrace: 123;
  readonly openBracket: 91;
  readonly openParen: 40;
  readonly percent: 37;
  readonly plus: 43;
  readonly question: 63;
  readonly semicolon: 59;
  readonly singleQuote: 39;
  readonly slash: 47;
  readonly tilde: 126;
  readonly backspace: 8;
  readonly formFeed: 12;
  readonly byteOrderMark: 65279;
  readonly tab: 9;
  readonly verticalTab: 11;
};
type SymbolTable = Map<string, TypeSymbol>;
type ColorTable = Map<string, ColorInfo>;
interface TypeSymbol {
  name: string;
  firstMention: SyntaxNode;
  references?: SyntaxNode[];
  members?: SymbolTable;
}
interface ColorInfo {
  node: SyntaxNode;
}
interface Color {
  readonly red: number;
  readonly green: number;
  readonly blue: number;
  readonly alpha: number;
}
type Omit<T, K extends keyof T> = Pick<T, Exclude<keyof T, K>>;
type StatementOf<T extends Statement["kind"]> = T extends typeof syntaxKind.SubGraphStatement ? SubGraphStatement : T extends typeof syntaxKind.AttributeStatement ? AttributeStatement : T extends typeof syntaxKind.EdgeStatement ? EdgeStatement : T extends typeof syntaxKind.IdEqualsIdStatement ? IdEqualsIdStatement : T extends typeof syntaxKind.NodeStatement ? NodeStatement : never;
//#endregion
//#region src/scanner.d.ts
interface Scanner {
  readonly end: number;
  readonly pos: number;
  readonly startPos: number;
  readonly tokenPos: number;
  readonly token: SyntaxKind;
  readonly tokenValue: string | undefined;
  readonly isUnterminated: boolean;
  readonly text: string;
  readonly onError: ErrorCallback | null;
  setText(newText?: string, start?: number, length?: number): void;
  setErrorCallback(cb: ErrorCallback): void;
  scan(skipTrivia: boolean): SyntaxKind;
  lookAhead(callback: () => SyntaxKind | boolean): SyntaxKind | boolean;
  tryScan(callback: () => SyntaxKind | boolean): SyntaxKind | boolean;
}
declare function getTokenAsText(token: SyntaxKind): string | undefined;
declare function getTextAsToken(token: string): SyntaxKind | undefined;
type ErrorCallback = (message: string, category: DiagnosticCategory, sub: ScanError, length: number) => void;
declare class DefaultScanner implements Scanner {
  #private;
  end: number;
  pos: number;
  startPos: number;
  tokenPos: number;
  token: SyntaxKind;
  tokenValue: string | undefined;
  tokenFlags: TokenFlags;
  isUnterminated: boolean;
  text: string;
  onError: ErrorCallback | null;
  setText(newText?: string, start?: number, length?: number): void;
  setErrorCallback(cb: ErrorCallback | null): void;
  scan(skipTrivia?: boolean): SyntaxKind;
  lookAhead<T extends SyntaxKind>(callback: () => T): T;
  tryScan<T extends SyntaxKind>(callback: () => T): T;
}
declare function isIdentifierStart(ch: number): boolean;
declare function skipTrivia(text: string, pos: number): number;
declare function isLineBreak(ch: number): boolean;
//#endregion
//#region src/parser.d.ts
type ParsingContext = (typeof parsingContext)[keyof typeof parsingContext];
declare const parsingContext: {
  readonly None: 0;
  readonly StatementList: 1;
  readonly AttributeContainerList: 2;
  readonly AssignmentList: 3;
  readonly EdgeRhsList: 4;
  readonly QuotedTextIdentifierConcatenation: 5;
  readonly Count: 6;
};
declare class Parser {
  #private;
  currentToken: SyntaxKind;
  nodeCount: number;
  identifiers: Set<string>;
  identifierCount: number;
  sourceText: string;
  scanner: Scanner;
  currentNodeHasError: boolean;
  currentContext: ParsingContext;
  diagnostics: DiagnosticMessage[];
  constructor();
  parse(sourceText: string): SourceFile;
}
declare function isIdentifier(kind: SyntaxKind): kind is 29 | 30 | 31 | 32;
declare function isIdentifierNode(node: SyntaxNode): node is Identifier;
//#endregion
//#region src/service/service.d.ts
interface DocumentLike {
  positionAt(offset: number): lst.Position;
  offsetAt(position: lst.Position): number;
  readonly uri: string;
}
interface CommandApplication {
  label?: string;
  edit: lst.WorkspaceEdit;
}
interface LanguageService {
  parseDocument(doc: TextDocument | string): SourceFile;
  validateDocument(doc: DocumentLike, sourceFile: SourceFile): lst.Diagnostic[];
  hover(doc: DocumentLike, sourceFile: SourceFile, position: lst.Position): lst.Hover | undefined;
  findReferences(doc: DocumentLike, sourceFile: SourceFile, position: lst.Position, context: lst.ReferenceContext): lst.Location[];
  findDefinition(doc: DocumentLike, sourceFile: SourceFile, position: lst.Position): lst.Location | undefined;
  renameSymbol(doc: DocumentLike, sourceFile: SourceFile, position: lst.Position, newName: string): lst.WorkspaceEdit | undefined;
  getCompletions(doc: DocumentLike, sourceFile: SourceFile, position: lst.Position): lst.CompletionItem[];
  getDocumentColors(doc: DocumentLike, sourceFile: SourceFile): ColorInformation[] | undefined;
  getColorRepresentations(doc: DocumentLike, sourceFile: SourceFile, color: Color$1, range: lst.Range): ColorPresentation[] | undefined;
  getCodeActions(doc: DocumentLike, sourceFile: SourceFile, range: lst.Range, context: lst.CodeActionContext): lst.Command[] | undefined;
  executeCommand(doc: DocumentLike, sourceFile: SourceFile, command: Omit<lst.Command, "title">): CommandApplication | undefined;
  getAvailableCommands(): string[];
}
declare function createService(): LanguageService;
//#endregion
//#region src/visitor.d.ts
declare function forEachChild<TReturn>(node: SyntaxNode, cbNode: (node: SyntaxNode) => TReturn, cbNodes?: (nodes: SyntaxNodeArray<SyntaxNode>) => TReturn): TReturn | undefined;
//#endregion
export { Assignment, AssignmentSeparator, AttributeContainer, AttributeStatement, CharacterCodes, CheckError, CheckErrorCode, Color, ColorInfo, ColorTable, CommandApplication, CompassPort, CompassPortDeclaration, DefaultScanner, DiagnosticCategory, DiagnosticMessage, DocumentLike, EdgeOp, EdgeRhs, EdgeSourceOrTarget, EdgeStatement, ErrorCallback, ErrorCode, ErrorSource, Graph, GraphContext, HtmlIdentifier, ID, IdEqualsIdStatement, Identifier, LanguageService, MutableSyntaxNodeArray, NodeId, NodeStatement, NormalPortDeclaration, NumericIdentifier, Omit, ParseError, ParseErrorCode, Parser, ParsingContext, PortDeclaration, QuotedTextIdentifier, ScanError, ScanErrorCode, Scanner, SourceFile, Statement, StatementBase, StatementOf, StatementSeparator, StringLiteral, SubGraph, SubGraphStatement, SymbolTable, SyntaxKind, SyntaxNode, SyntaxNodeArray, SyntaxNodeFlags, TextIdentifier, TextRange, Token, TokenFlags, TypeSymbol, characterCodes, checkError, createService, diagnosticCategory, errorSource, forEachChild, getTextAsToken, getTokenAsText, graphContext, isIdentifier, isIdentifierNode, isIdentifierStart, isLineBreak, parseError, parsingContext, scanError, skipTrivia, syntaxKind, syntaxKindNames, syntaxNodeFlags, tokenFlags };