/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.ColonyPlan;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.WorkLocationPlan;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class ColonyPlanTest
extends FreeColTestCase {
    private static final BuildingType blacksmithShopType = ColonyPlanTest.spec().getBuildingType("model.building.blacksmithShop");
    private static final BuildingType lumberMillType = ColonyPlanTest.spec().getBuildingType("model.building.lumberMill");
    private static final BuildingType townHallType = ColonyPlanTest.spec().getBuildingType("model.building.townHall");
    private static final GoodsType bellsType = ColonyPlanTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType cottonType = ColonyPlanTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType clothType = ColonyPlanTest.spec().getGoodsType("model.goods.cloth");
    private static final GoodsType foodType = ColonyPlanTest.spec().getPrimaryFoodType();
    private static final GoodsType grainType = ColonyPlanTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType sugarType = ColonyPlanTest.spec().getGoodsType("model.goods.sugar");
    private static final GoodsType tobaccoType = ColonyPlanTest.spec().getGoodsType("model.goods.tobacco");
    private static final GoodsType rumType = ColonyPlanTest.spec().getGoodsType("model.goods.rum");
    private static final GoodsType hammersType = ColonyPlanTest.spec().getGoodsType("model.goods.hammers");
    private static final GoodsType lumberType = ColonyPlanTest.spec().getGoodsType("model.goods.lumber");
    private static final GoodsType oreType = ColonyPlanTest.spec().getGoodsType("model.goods.ore");
    private static final GoodsType toolsType = ColonyPlanTest.spec().getGoodsType("model.goods.tools");
    private static final TileType forestType = ColonyPlanTest.spec().getTileType("model.tile.coniferForest");
    private static final TileType mountainType = ColonyPlanTest.spec().getTileType("model.tile.mountains");
    private static final TileType prairieType = ColonyPlanTest.spec().getTileType("model.tile.prairie");
    private static final TileType savannahType = ColonyPlanTest.spec().getTileType("model.tile.savannah");
    private static final TileImprovementType clearForest = ColonyPlanTest.spec().getTileImprovementType("model.improvement.clearForest");
    private static final TileImprovementType fishBonusLand = ColonyPlanTest.spec().getTileImprovementType("model.improvement.fishBonusLand");
    private static final TileImprovementType fishBonusRiver = ColonyPlanTest.spec().getTileImprovementType("model.improvement.fishBonusRiver");
    private static final TileImprovementType plow = ColonyPlanTest.spec().getTileImprovementType("model.improvement.plow");
    private static final TileImprovementType river = ColonyPlanTest.spec().getTileImprovementType("model.improvement.river");
    private static final TileImprovementType road = ColonyPlanTest.spec().getTileImprovementType("model.improvement.road");
    private static final TileType arctic = ColonyPlanTest.spec().getTileType("model.tile.arctic");
    private static final TileType desert = ColonyPlanTest.spec().getTileType("model.tile.desert");
    private static final TileType desertForest = ColonyPlanTest.spec().getTileType("model.tile.scrubForest");
    private static final TileType grassland = ColonyPlanTest.spec().getTileType("model.tile.grassland");
    private static final TileType grasslandForest = ColonyPlanTest.spec().getTileType("model.tile.coniferForest");
    private static final TileType highSeas = ColonyPlanTest.spec().getTileType("model.tile.highSeas");
    private static final TileType hills = ColonyPlanTest.spec().getTileType("model.tile.hills");
    private static final TileType marsh = ColonyPlanTest.spec().getTileType("model.tile.marsh");
    private static final TileType marshForest = ColonyPlanTest.spec().getTileType("model.tile.wetlandForest");
    private static final TileType mountains = ColonyPlanTest.spec().getTileType("model.tile.mountains");
    private static final TileType ocean = ColonyPlanTest.spec().getTileType("model.tile.ocean");
    private static final TileType plains = ColonyPlanTest.spec().getTileType("model.tile.plains");
    private static final TileType plainsForest = ColonyPlanTest.spec().getTileType("model.tile.mixedForest");
    private static final TileType prairie = ColonyPlanTest.spec().getTileType("model.tile.prairie");
    private static final TileType prairieForest = ColonyPlanTest.spec().getTileType("model.tile.broadleafForest");
    private static final TileType savannah = ColonyPlanTest.spec().getTileType("model.tile.savannah");
    private static final TileType savannahForest = ColonyPlanTest.spec().getTileType("model.tile.tropicalForest");
    private static final TileType swamp = ColonyPlanTest.spec().getTileType("model.tile.swamp");
    private static final TileType swampForest = ColonyPlanTest.spec().getTileType("model.tile.rainForest");
    private static final TileType tundra = ColonyPlanTest.spec().getTileType("model.tile.tundra");
    private static final TileType tundraForest = ColonyPlanTest.spec().getTileType("model.tile.borealForest");
    private static final UnitType farmerType = ColonyPlanTest.spec().getUnitType("model.unit.expertFarmer");
    private static final UnitType colonistType = ColonyPlanTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType servantType = ColonyPlanTest.spec().getUnitType("model.unit.indenturedServant");
    private static final UnitType convertType = ColonyPlanTest.spec().getUnitType("model.unit.indianConvert");
    private static final UnitType criminalType = ColonyPlanTest.spec().getUnitType("model.unit.pettyCriminal");
    private static final UnitType sugarPlanterType = ColonyPlanTest.spec().getUnitType("model.unit.masterSugarPlanter");
    private static final LogBuilder lb = new LogBuilder(0);

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    private Map buildMap(boolean withBuildRawMat) {
        FreeColTestCase.MapBuilder builder = new FreeColTestCase.MapBuilder(ColonyPlanTest.getGame());
        if (withBuildRawMat) {
            builder.setTileType(4, 8, forestType);
            builder.setTileType(6, 8, mountainType);
        }
        return builder.build();
    }

    private boolean shouldProduce(ColonyPlan plan, GoodsType type) {
        List<WorkLocationPlan> plans = type.isFoodType() ? plan.getFoodPlans() : plan.getWorkPlans();
        for (WorkLocationPlan wlp : plans) {
            if (wlp.getGoodsType() != type) continue;
            return true;
        }
        return false;
    }

    public void testReqLumberAndHammersForBuild() {
        ServerGame game = ServerTestHelper.startServerGame(this.buildMap(true));
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        Colony colony = this.getStandardColony(4);
        ColonyPlan plan = new ColonyPlan(aiMain, colony);
        plan.update();
        ColonyPlanTest.assertEquals((String)"The colony should plan to build the lumber mill", (Object)lumberMillType, (Object)plan.getBuildableTypes().get(0));
        ColonyPlanTest.assertTrue((String)"The colony should plan to produce lumber", (boolean)this.shouldProduce(plan, lumberType));
        ColonyPlanTest.assertTrue((String)"The colony should plan to produce hammers", (boolean)this.shouldProduce(plan, hammersType));
    }

    public void testReqOreAndToolsWithEnoughHammersForBuild() {
        ServerGame game = ServerTestHelper.startServerGame(this.buildMap(true));
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        Colony colony = this.getStandardColony(4);
        ColonyPlan plan = new ColonyPlan(aiMain, colony);
        plan.update();
        colony.addGoods(hammersType, blacksmithShopType.getRequiredAmountOf(hammersType));
        colony.setCurrentlyBuilding(blacksmithShopType);
        plan.refine(blacksmithShopType, lb);
        ColonyPlanTest.assertTrue((String)"The colony should plan to produce ore", (boolean)this.shouldProduce(plan, oreType));
        ColonyPlanTest.assertTrue((String)"The colony should plan to produce tools", (boolean)this.shouldProduce(plan, toolsType));
        ColonyPlanTest.assertFalse((String)"The colony should not produce hammers, has enough", (boolean)this.shouldProduce(plan, hammersType));
    }

    public void testNoBuildRawMatTiles() {
        ServerGame game = ServerTestHelper.startServerGame(this.buildMap(false));
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        Colony colony = this.getStandardColony(4);
        colony.addGoods(lumberType, 100);
        colony.addGoods(oreType, 100);
        ColonyPlan plan = new ColonyPlan(aiMain, colony);
        plan.update();
        plan.refine(colony.getCurrentlyBuilding(), lb);
        ColonyPlanTest.assertFalse((String)"The colony can not produce lumber, none available", (boolean)this.shouldProduce(plan, lumberType));
        ColonyPlanTest.assertTrue((String)"The colony should produce hammers, has lumber in stock", (boolean)this.shouldProduce(plan, hammersType));
        plan.update();
        colony.addGoods(hammersType, blacksmithShopType.getRequiredAmountOf(hammersType));
        colony.setCurrentlyBuilding(blacksmithShopType);
        plan.refine(blacksmithShopType, lb);
        ColonyPlanTest.assertFalse((String)"The colony should not produce hammers, has enough", (boolean)this.shouldProduce(plan, hammersType));
        ColonyPlanTest.assertFalse((String)"The colony can not produce ore, none available", (boolean)this.shouldProduce(plan, oreType));
        ColonyPlanTest.assertTrue((String)"The colony should produce tools, has ore in stock", (boolean)this.shouldProduce(plan, toolsType));
    }

    public void testGetBestWorker() {
        ServerGame game = ServerTestHelper.startServerGame(ColonyPlanTest.getTestMap(savannahType));
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        Colony colony = this.getStandardColony();
        game.setCurrentPlayer(colony.getOwner());
        Player dutch = ColonyPlanTest.getGame().getPlayerByNationId("model.nation.dutch");
        ArrayList<Unit> units = new ArrayList<Unit>();
        ServerUnit servant = new ServerUnit(ColonyPlanTest.getGame(), colony.getTile(), dutch, servantType);
        units.add(servant);
        Building townHall = colony.getBuilding(townHallType);
        ColonyTile colonyTile = null;
        for (ColonyTile ct : colony.getColonyTiles()) {
            if (ct.isFull()) continue;
            colonyTile = ct;
            break;
        }
        ColonyPlanTest.assertNotNull(colonyTile);
        ColonyPlanTest.assertNull((Object)ColonyPlan.getBestWorker(colonyTile, sugarType, null));
        ColonyPlanTest.assertNull((Object)ColonyPlan.getBestWorker(colonyTile, sugarType, new ArrayList<Unit>()));
        ColonyPlanTest.assertEquals((Object)servant, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)servant, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
        ColonyPlanTest.assertEquals((Object)servant, (Object)ColonyPlan.getBestWorker(townHall, bellsType, units));
        ColonyPlanTest.assertNull((Object)ColonyPlan.getBestWorker(townHall, grainType, units));
        ServerUnit criminal = new ServerUnit(ColonyPlanTest.getGame(), colony.getTile(), dutch, criminalType);
        units.add(criminal);
        ColonyPlanTest.assertEquals((Object)criminal, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)criminal, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
        ColonyPlanTest.assertEquals((Object)servant, (Object)ColonyPlan.getBestWorker(townHall, bellsType, units));
        ServerUnit colonist1 = new ServerUnit(ColonyPlanTest.getGame(), colony.getTile(), dutch, colonistType);
        units.add(colonist1);
        ColonyPlanTest.assertEquals((Object)colonist1, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)colonist1, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
        ColonyPlanTest.assertEquals((Object)colonist1, (Object)ColonyPlan.getBestWorker(townHall, bellsType, units));
        ServerUnit colonist2 = new ServerUnit(ColonyPlanTest.getGame(), colony.getTile(), dutch, colonistType);
        units.add(colonist2);
        colonist2.changeWorkType(sugarType);
        colonist2.modifyExperience(100);
        ColonyPlanTest.assertEquals((Object)colonist2, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)colonist1, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
        ColonyPlanTest.assertEquals((Object)colonist1, (Object)ColonyPlan.getBestWorker(townHall, bellsType, units));
        colonist1.changeWorkType(lumberType);
        colonist1.modifyExperience(80);
        ColonyPlanTest.assertNull((Object)ColonyPlan.getBestWorker(colonyTile, lumberType, units));
        ColonyPlanTest.assertEquals((Object)colonist2, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)colonist1, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
        ColonyPlanTest.assertEquals((Object)colonist1, (Object)ColonyPlan.getBestWorker(townHall, bellsType, units));
        ServerUnit convert = new ServerUnit(ColonyPlanTest.getGame(), colony.getTile(), dutch, convertType);
        units.add(convert);
        ColonyPlanTest.assertEquals((Object)convert, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)convert, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
        units.remove(convert);
        ServerUnit sugarPlanter = new ServerUnit(ColonyPlanTest.getGame(), colony.getTile(), dutch, sugarPlanterType);
        units.add(sugarPlanter);
        ColonyPlanTest.assertEquals((Object)sugarPlanter, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)colonist1, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
        ColonyPlanTest.assertEquals((Object)sugarPlanter, (Object)ColonyPlan.getBestWorker(townHall, bellsType, units));
        units.remove(sugarPlanter);
        ServerUnit farmer = new ServerUnit(ColonyPlanTest.getGame(), colony.getTile(), dutch, farmerType);
        units.add(farmer);
        ColonyPlanTest.assertEquals((Object)colonist2, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)farmer, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
        ColonyPlanTest.assertEquals((Object)farmer, (Object)ColonyPlan.getBestWorker(townHall, bellsType, units));
        units.add(convert);
        units.add(sugarPlanter);
        ColonyPlanTest.assertEquals((Object)sugarPlanter, (Object)ColonyPlan.getBestWorker(colonyTile, sugarType, units));
        ColonyPlanTest.assertEquals((Object)farmer, (Object)ColonyPlan.getBestWorker(colonyTile, grainType, units));
    }

    public void testBestImprovements() throws Exception {
        Game game = ColonyPlanTest.getStandardGame();
        Map map = ColonyPlanTest.getTestMap(plains);
        game.changeMap(map);
        Tile tile1 = map.getTile(5, 8);
        tile1.setType(savannah);
        ColonyPlanTest.assertEquals((Object)plow, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, grainType));
        ColonyPlanTest.assertEquals((Object)plow, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, sugarType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, tobaccoType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, lumberType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, oreType));
        tile1.setType(marsh);
        ColonyPlanTest.assertEquals((Object)plow, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, grainType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, sugarType));
        ColonyPlanTest.assertEquals((Object)plow, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, tobaccoType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, lumberType));
        ColonyPlanTest.assertEquals((Object)road, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, oreType));
        tile1.setType(savannahForest);
        ColonyPlanTest.assertEquals((Object)clearForest, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, grainType));
        ColonyPlanTest.assertEquals((Object)clearForest, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, sugarType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, tobaccoType));
        ColonyPlanTest.assertEquals((Object)road, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, lumberType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, oreType));
        tile1.setType(hills);
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, grainType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, sugarType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, tobaccoType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, lumberType));
        ColonyPlanTest.assertEquals((Object)road, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, oreType));
        tile1.setType(arctic);
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, grainType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, sugarType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, tobaccoType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, lumberType));
        ColonyPlanTest.assertEquals(null, (Object)TileImprovementPlan.getBestTileImprovementType(tile1, oreType));
    }
}

