/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import net.infonode.properties.base.Property;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.util.PropertyChangeListener;

public class PropertyMapWeakListenerManager {
    private static WeakHashMap listenerMap = new WeakHashMap();
    private static WeakHashMap propertyChangeListenerMap = new WeakHashMap();
    private static WeakHashMap treeListenerMap = new WeakHashMap();
    private static ReferenceQueue refQueue = new ReferenceQueue();
    private static ListenerRef ref;
    private static Runnable refRemover;

    static {
        refRemover = new Runnable(){

            @Override
            public void run() {
                while (ref != null) {
                    ref.removeFromMap();
                    ref = (ListenerRef)refQueue.poll();
                }
            }
        };
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        ref = (ListenerRef)refQueue.remove();
                        SwingUtilities.invokeAndWait(refRemover);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private PropertyMapWeakListenerManager() {
    }

    private static void addToMap(WeakHashMap map, Object key, Object value) {
        ArrayList<Object> l = (ArrayList<Object>)map.get(key);
        if (l == null) {
            l = new ArrayList<Object>(2);
            map.put(key, l);
        }
        l.add(value);
    }

    private static void removeFromMap(WeakHashMap map, Object key, PropertyMap propertyMap) {
        ArrayList l = (ArrayList)map.get(key);
        if (l != null) {
            int i = 0;
            while (i < l.size()) {
                ListenerRef ref = (ListenerRef)l.get(i);
                if (ref.getMap() == propertyMap) {
                    ref.removeFromMap();
                    l.remove(i);
                    if (l.size() == 0) {
                        map.remove(key);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    private static void removeFromMap(WeakHashMap map, Object key, PropertyMap propertyMap, Property property) {
        ArrayList l = (ArrayList)map.get(key);
        if (l != null) {
            int i = 0;
            while (i < l.size()) {
                PropertyChangeListenerRef ref = (PropertyChangeListenerRef)l.get(i);
                if (ref.getMap() == propertyMap && ref.getProperty() == property) {
                    ref.removeFromMap();
                    l.remove(i);
                    if (l.size() == 0) {
                        map.remove(key);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    public static void addWeakListener(PropertyMap map, PropertyMapListener listener) {
        MapListenerRef l = new MapListenerRef(listener, refQueue, map);
        PropertyMapWeakListenerManager.addToMap(listenerMap, listener, l);
    }

    public static void addWeakPropertyChangeListener(PropertyMap map, Property property, PropertyChangeListener listener) {
        PropertyChangeListenerRef l = new PropertyChangeListenerRef(listener, refQueue, map, property);
        PropertyMapWeakListenerManager.addToMap(propertyChangeListenerMap, listener, l);
    }

    public static void addWeakTreeListener(PropertyMap map, PropertyMapTreeListener listener) {
        TreeListenerRef l = new TreeListenerRef(listener, refQueue, map);
        PropertyMapWeakListenerManager.addToMap(treeListenerMap, listener, l);
    }

    public static void removeWeakListener(PropertyMap map, PropertyMapListener listener) {
        PropertyMapWeakListenerManager.removeFromMap(listenerMap, listener, map);
    }

    public static void removeWeakPropertyChangeListener(PropertyMap map, Property property, PropertyChangeListener listener) {
        PropertyMapWeakListenerManager.removeFromMap(propertyChangeListenerMap, listener, map, property);
    }

    public static void removeWeakTreeListener(PropertyMap map, PropertyMapTreeListener listener) {
        PropertyMapWeakListenerManager.removeFromMap(treeListenerMap, listener, map);
    }

    private static class ListenerRef
    extends WeakReference {
        private PropertyMap map;

        protected ListenerRef(Object referent, ReferenceQueue q, PropertyMap map) {
            super(referent, q);
            this.map = map;
        }

        public PropertyMap getMap() {
            return this.map;
        }

        public void removeFromMap() {
            this.map = null;
        }
    }

    private static class MapListenerRef
    extends ListenerRef
    implements PropertyMapListener {
        MapListenerRef(PropertyMapListener referent, ReferenceQueue q, PropertyMap map) {
            super(referent, q, map);
            map.addListener(this);
        }

        @Override
        public void removeFromMap() {
            this.getMap().removeListener(this);
            super.removeFromMap();
        }

        @Override
        public void propertyValuesChanged(PropertyMap propertyMap, Map changes) {
            PropertyMapListener l = (PropertyMapListener)this.get();
            if (l != null) {
                l.propertyValuesChanged(propertyMap, changes);
            }
        }
    }

    private static class PropertyChangeListenerRef
    extends ListenerRef
    implements PropertyChangeListener {
        private Property property;

        PropertyChangeListenerRef(PropertyChangeListener referent, ReferenceQueue q, PropertyMap map, Property property) {
            super(referent, q, map);
            this.property = property;
            map.addPropertyChangeListener(property, this);
        }

        public Property getProperty() {
            return this.property;
        }

        @Override
        public void removeFromMap() {
            this.getMap().removePropertyChangeListener(this.property, this);
            super.removeFromMap();
        }

        @Override
        public void propertyChanged(Property property, Object valueContainer, Object oldValue, Object newValue) {
            PropertyChangeListener l = (PropertyChangeListener)this.get();
            if (l != null) {
                l.propertyChanged(property, valueContainer, oldValue, newValue);
            }
        }
    }

    private static class TreeListenerRef
    extends ListenerRef
    implements PropertyMapTreeListener {
        TreeListenerRef(PropertyMapTreeListener referent, ReferenceQueue q, PropertyMap map) {
            super(referent, q, map);
            map.addTreeListener(this);
        }

        @Override
        public void removeFromMap() {
            this.getMap().removeTreeListener(this);
            super.removeFromMap();
        }

        @Override
        public void propertyValuesChanged(Map changes) {
            PropertyMapTreeListener l = (PropertyMapTreeListener)this.get();
            if (l != null) {
                l.propertyValuesChanged(changes);
            }
        }
    }
}

