/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.link.ILinkView;

abstract class AConnectorView
implements ILinkView {
    protected final ConnectorModel viewedConnector;
    protected final NodeView source;
    protected final NodeView target;

    protected double getZoom() {
        return this.getMap().getZoom();
    }

    protected int getZoomed(int i) {
        return this.getMap().getZoomed(i);
    }

    protected MapView getMap() {
        return this.source == null ? this.target.getMap() : this.source.getMap();
    }

    protected Polygon paintArrow(Point from, Point to, Graphics2D g, double size, ArrowDirection direction) {
        if (from.equals(to)) {
            return null;
        }
        Polygon p = this.createArrowShape(from, to, size, direction);
        if (p == null) {
            return null;
        }
        g.fillPolygon(p);
        g.drawPolygon(p);
        return p;
    }

    private Polygon createArrowShape(Point from, Point to, double size, ArrowDirection direction) {
        Point2D directionPoint = this.createArrowDirection(from, to, size);
        if (directionPoint == null) {
            return null;
        }
        return direction == ArrowDirection.INCOMING ? this.incomingArrowShape(to, directionPoint) : this.outgoingArrowShape(to, directionPoint);
    }

    private Point2D createArrowDirection(Point from, Point to, double size) {
        int dx = from.x - to.x;
        int dy = from.y - to.y;
        int r2 = dx * dx + dy * dy;
        if (r2 == 0) {
            return null;
        }
        double length = Math.sqrt(r2);
        double dxn = size * (double)dx / length;
        double dyn = size * (double)dy / length;
        Point2D.Double direction = new Point2D.Double(dxn, dyn);
        return direction;
    }

    private Polygon outgoingArrowShape(Point from, Point2D direction) {
        double arrowWidth = 0.33;
        double dxn = direction.getX();
        double dyn = direction.getY();
        Polygon p = new Polygon();
        p.addPoint((int)((double)from.x + dxn), (int)((double)from.y + dyn));
        p.addPoint((int)((double)from.x + 0.33 * dyn), (int)((double)from.y - 0.33 * dxn));
        p.addPoint((int)((double)from.x + dxn * 0.7), (int)((double)from.y + dyn * 0.7));
        p.addPoint((int)((double)from.x - 0.33 * dyn), (int)((double)from.y + 0.33 * dxn));
        p.addPoint((int)((double)from.x + dxn), (int)((double)from.y + dyn));
        return p;
    }

    private Polygon incomingArrowShape(Point to, Point2D direction) {
        double arrowWidth = 0.5;
        double dxn = direction.getX();
        double dyn = direction.getY();
        Polygon p = new Polygon();
        p.addPoint(to.x, to.y);
        p.addPoint((int)((double)to.x + dxn + 0.5 * dyn), (int)((double)to.y + dyn - 0.5 * dxn));
        p.addPoint((int)((double)to.x + dxn * 0.8), (int)((double)to.y + dyn * 0.8));
        p.addPoint((int)((double)to.x + dxn - 0.5 * dyn), (int)((double)to.y + dyn + 0.5 * dxn));
        p.addPoint(to.x, to.y);
        return p;
    }

    NodeView getSource() {
        return this.source;
    }

    NodeView getTarget() {
        return this.target;
    }

    protected boolean isSourceVisible() {
        return this.source != null && this.source.isContentVisible();
    }

    protected boolean isTargetVisible() {
        return this.target != null && this.target.isContentVisible();
    }

    public AConnectorView(ConnectorModel connectorModel, NodeView source, NodeView target) {
        this.viewedConnector = connectorModel;
        this.source = source;
        this.target = target;
    }

    static enum ArrowDirection {
        INCOMING,
        OUTGOING;

    }
}

