/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.Connectors;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.link.ConnectorView;
import org.freeplane.view.swing.map.link.InclinationRecommender;
import org.freeplane.view.swing.ui.DefaultMapMouseListener;

public class MMapMouseListener
extends DefaultMapMouseListener {
    ConnectorView connectorView = null;
    private Point connectorOldEndPoint;
    private Point connectorOldStartPoint;

    public void mouseDragged(MouseEvent e) {
        Point changedInclination;
        MapView mapView = (MapView)e.getComponent();
        if (this.connectorView == null || !mapView.getLayoutType().equals((Object)MapViewLayout.MAP)) {
            super.mouseDragged(e);
            return;
        }
        if (this.originX == -1) {
            return;
        }
        ConnectorModel connector = this.connectorView.getConnector();
        NodeModel target = connector.getTarget();
        if (target == null) {
            super.mouseDragged(e);
            return;
        }
        int deltaX = (int)((float)(e.getX() - this.originX) / mapView.getZoom());
        int deltaY = (int)((float)(e.getY() - this.originY) / mapView.getZoom());
        double distSqToTarget = 0.0;
        double distSqToSource = 0.0;
        NodeView targetView = mapView.getNodeView(target);
        NodeView sourceView = mapView.getNodeView(connector.getSource());
        if (targetView != null && sourceView != null) {
            Point targetLinkPoint = targetView.getLinkPoint(connector.getEndInclination());
            Point sourceLinkPoint = sourceView.getLinkPoint(connector.getStartInclination());
            distSqToTarget = targetLinkPoint.distanceSq(this.originX, this.originY);
            distSqToSource = sourceLinkPoint.distanceSq(this.originX, this.originY);
        }
        if (connector.getStartInclination() == null || connector.getEndInclination() == null) {
            InclinationRecommender recommender = new InclinationRecommender((LinkController)this.linkController(), this.connectorView);
            if (connector.getStartInclination() == null) {
                connector.setStartInclination(recommender.calcStartInclination());
            }
            if (connector.getEndInclination() == null) {
                connector.setEndInclination(recommender.calcEndInclination());
            }
        }
        if ((targetView == null || sourceView != null) && distSqToSource <= distSqToTarget * 2.25) {
            changedInclination = connector.getStartInclination();
            connector.changeInclination(deltaX, deltaY, mapView.getRoot().getNode(), connector.getSource(), changedInclination);
            connector.setStartInclination(changedInclination);
        }
        if ((sourceView == null || targetView != null) && distSqToTarget <= distSqToSource * 2.25) {
            changedInclination = connector.getEndInclination();
            connector.changeInclination(deltaX, deltaY, mapView.getRoot().getNode(), target, changedInclination);
            connector.setEndInclination(changedInclination);
        }
        this.originX = e.getX();
        this.originY = e.getY();
        mapView.repaintVisible();
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (Compat.isPopupTrigger((MouseEvent)e)) {
            return;
        }
        if (!SwingUtilities.getWindowAncestor(e.getComponent()).isFocused()) {
            return;
        }
        MapView mapView = (MapView)e.getComponent();
        if (!mapView.isValid()) {
            return;
        }
        if (mapView.getClientProperty(Connectors.class) != null) {
            return;
        }
        Object object = mapView.detectView(new Point(this.originX, this.originY));
        if (object instanceof ConnectorView) {
            this.connectorView = (ConnectorView)object;
            ConnectorModel connector = this.connectorView.getConnector();
            ConnectorShape shape = this.linkController().getShape(connector);
            if (ConnectorShape.EDGE_LIKE.equals((Object)shape)) {
                return;
            }
            this.connectorOldStartPoint = connector.getStartInclination();
            this.connectorOldEndPoint = connector.getEndInclination();
            this.connectorView.enableControlPoints();
            mapView.repaintVisible();
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.connectorView != null) {
            ConnectorModel connector = this.connectorView.getConnector();
            Point connectorNewStartPoint = connector.getStartInclination();
            Point connectorNewEndPoint = connector.getEndInclination();
            connector.setStartInclination(this.connectorOldStartPoint);
            connector.setEndInclination(this.connectorOldEndPoint);
            this.linkController().setArrowLinkEndPoints(connector, connectorNewStartPoint, connectorNewEndPoint);
            this.connectorView.disableControlPoints();
            MapView mapView = (MapView)e.getComponent();
            mapView.repaintVisible();
            this.connectorView = null;
        }
    }

    private MLinkController linkController() {
        return (MLinkController)LinkController.getController((ModeController)Controller.getCurrentController().getModeController());
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && Compat.isCtrlEvent((MouseEvent)e)) {
            MapView mapView = (MapView)e.getComponent();
            Object object = mapView.detectView(new Point(this.originX, this.originY));
            if (object != null) {
                return;
            }
            ModeController modeController = Controller.getCurrentModeController();
            IExtension freeNode = modeController.getExtension(FreeNode.class);
            if (freeNode != null && modeController instanceof MModeController) {
                boolean newNodeIsLeft;
                NodeView root = mapView.getRoot();
                MainView rootContent = root.getMainView();
                Point contentPt = new Point();
                UITools.convertPointToAncestor((Component)rootContent, (Point)contentPt, (Component)mapView);
                float zoom = mapView.getZoom();
                Point eventPoint = e.getPoint();
                int x = (int)((float)(eventPoint.x - contentPt.x) / zoom);
                int y = (int)((float)(eventPoint.y - contentPt.y) / zoom);
                int rootContentNormalWidth = (int)((float)rootContent.getWidth() / zoom);
                boolean bl = newNodeIsLeft = x < rootContentNormalWidth / 2;
                if (newNodeIsLeft) {
                    x = rootContentNormalWidth - x;
                }
                Point pt = new Point(x, y);
                ((MMapController)modeController.getMapController()).addFreeNode(root.getNode(), pt, newNodeIsLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
            }
        } else {
            super.mouseClicked(e);
        }
    }
}

